/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.client;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.webauthn4j.converter.AttestationObjectConverter;
import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.request.AttestationConveyancePreference;
import com.webauthn4j.request.PublicKeyCredentialCreationOptions;
import com.webauthn4j.request.PublicKeyCredentialRequestOptions;
import com.webauthn4j.request.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.request.extension.client.SupportedExtensionsExtensionClientInput;
import com.webauthn4j.response.AuthenticatorAssertionResponse;
import com.webauthn4j.response.AuthenticatorAttestationResponse;
import com.webauthn4j.response.AuthenticatorResponse;
import com.webauthn4j.response.PublicKeyCredential;
import com.webauthn4j.response.attestation.AttestationObject;
import com.webauthn4j.response.attestation.statement.AttestationStatement;
import com.webauthn4j.response.attestation.statement.NoneAttestationStatement;
import com.webauthn4j.response.client.ClientDataType;
import com.webauthn4j.response.client.CollectedClientData;
import com.webauthn4j.response.client.Origin;
import com.webauthn4j.response.client.TokenBinding;
import com.webauthn4j.response.client.TokenBindingStatus;
import com.webauthn4j.response.client.challenge.Challenge;
import com.webauthn4j.response.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.response.extension.client.SupportedExtensionsExtensionClientOutput;
import com.webauthn4j.test.authenticator.AuthenticatorAdaptor;
import com.webauthn4j.test.authenticator.CredentialCreationResponse;
import com.webauthn4j.test.authenticator.CredentialRequestResponse;
import com.webauthn4j.test.authenticator.model.WebAuthnModelAuthenticatorAdaptor;
import com.webauthn4j.test.client.AuthenticationEmulationOption;
import com.webauthn4j.test.client.NoAuthenticatorSuccessException;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import com.webauthn4j.util.WIP;
import com.webauthn4j.util.exception.NotImplementedException;
import com.webauthn4j.validator.exception.ValidationException;
import java.util.Collections;

@WIP
public class ClientPlatform {
    private ObjectMapper objectMapper = new ObjectMapper();
    private AttestationObjectConverter attestationObjectConverter = new AttestationObjectConverter((ObjectCodec)this.objectMapper);
    private CollectedClientDataConverter collectedClientDataConverter = new CollectedClientDataConverter((ObjectCodec)this.objectMapper);
    private Origin origin;
    private AuthenticatorAdaptor authenticatorAdaptor;

    public ClientPlatform(Origin origin, AuthenticatorAdaptor authenticatorAdaptor) {
        this.origin = origin;
        this.authenticatorAdaptor = authenticatorAdaptor;
    }

    public ClientPlatform(AuthenticatorAdaptor authenticatorAdaptor) {
        this(new Origin("https://example.com"), authenticatorAdaptor);
    }

    public ClientPlatform(Origin origin) {
        this(origin, new WebAuthnModelAuthenticatorAdaptor());
    }

    public ClientPlatform() {
        this(new Origin("https://example.com"));
    }

    public PublicKeyCredential<AuthenticatorAttestationResponse> create(PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions, RegistrationEmulationOption registrationEmulationOption) {
        CollectedClientData collectedClientData = registrationEmulationOption.isCollectedClientDataOverrideEnabled() ? registrationEmulationOption.getCollectedClientData() : this.createCollectedClientData(ClientDataType.CREATE, publicKeyCredentialCreationOptions.getChallenge());
        if (this.authenticatorAdaptor == null) {
            throw new NoAuthenticatorSuccessException();
        }
        CredentialCreationResponse credentialCreationResponse = this.authenticatorAdaptor.register(publicKeyCredentialCreationOptions, collectedClientData, registrationEmulationOption);
        AttestationObject attestationObject = credentialCreationResponse.getAttestationObject();
        AttestationStatement attestationStatement = credentialCreationResponse.getAttestationObject().getAttestationStatement();
        AttestationConveyancePreference attestationConveyancePreference = publicKeyCredentialCreationOptions.getAttestation();
        if (attestationConveyancePreference == null) {
            attestationConveyancePreference = AttestationConveyancePreference.NONE;
        }
        switch (attestationConveyancePreference) {
            case DIRECT: {
                break;
            }
            case INDIRECT: {
                throw new NotImplementedException();
            }
            case NONE: {
                attestationStatement = new NoneAttestationStatement();
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
        attestationObject = new AttestationObject(attestationObject.getAuthenticatorData(), attestationStatement);
        byte[] attestationObjectBytes = this.attestationObjectConverter.convertToBytes(attestationObject);
        byte[] credentialId = credentialCreationResponse.getAttestationObject().getAuthenticatorData().getAttestedCredentialData().getCredentialId();
        byte[] collectedClientDataBytes = this.collectedClientDataConverter.convertToBytes(collectedClientData);
        AuthenticationExtensionsClientOutputs clientExtensions = this.processRegistrationExtensions(publicKeyCredentialCreationOptions.getExtensions());
        return new PublicKeyCredential(credentialId, (AuthenticatorResponse)new AuthenticatorAttestationResponse(collectedClientDataBytes, attestationObjectBytes), clientExtensions);
    }

    private AuthenticationExtensionsClientOutputs processRegistrationExtensions(AuthenticationExtensionsClientInputs extensions) {
        if (extensions == null) {
            extensions = new AuthenticationExtensionsClientInputs();
        }
        AuthenticationExtensionsClientOutputs map = new AuthenticationExtensionsClientOutputs();
        extensions.forEach((key, value) -> {
            switch (key) {
                case "exts": {
                    SupportedExtensionsExtensionClientInput clientExtensionInput = (SupportedExtensionsExtensionClientInput)value;
                    if (!((Boolean)clientExtensionInput.getValue()).booleanValue()) break;
                    map.put(key, (Object)new SupportedExtensionsExtensionClientOutput(Collections.singletonList("exts")));
                }
            }
        });
        return map;
    }

    private AuthenticationExtensionsClientOutputs processAuthenticationExtensions(AuthenticationExtensionsClientInputs extensions) {
        if (extensions == null) {
            extensions = new AuthenticationExtensionsClientInputs();
        }
        AuthenticationExtensionsClientOutputs map = new AuthenticationExtensionsClientOutputs();
        extensions.forEach((key, value) -> key.getClass());
        return map;
    }

    public PublicKeyCredential<AuthenticatorAttestationResponse> create(PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions) {
        return this.create(publicKeyCredentialCreationOptions, new RegistrationEmulationOption());
    }

    public PublicKeyCredential<AuthenticatorAssertionResponse> get(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, CollectedClientData collectedClientData, AuthenticationEmulationOption authenticationEmulationOption) {
        NoAuthenticatorSuccessException noAuthenticatorSuccessException = new NoAuthenticatorSuccessException();
        if (this.authenticatorAdaptor == null) {
            throw noAuthenticatorSuccessException;
        }
        try {
            CredentialRequestResponse credentialRequestResponse = this.authenticatorAdaptor.authenticate(publicKeyCredentialRequestOptions, collectedClientData, authenticationEmulationOption);
            byte[] credentialId = credentialRequestResponse.getCredentialId();
            AuthenticationExtensionsClientOutputs clientExtensions = this.processAuthenticationExtensions(publicKeyCredentialRequestOptions.getExtensions());
            return new PublicKeyCredential(credentialId, (AuthenticatorResponse)new AuthenticatorAssertionResponse(credentialRequestResponse.getCollectedClientDataBytes(), credentialRequestResponse.getAuthenticatorDataBytes(), credentialRequestResponse.getSignature(), credentialRequestResponse.getUserHandle()), clientExtensions);
        }
        catch (ValidationException e) {
            noAuthenticatorSuccessException.addSuppressed(e);
            throw noAuthenticatorSuccessException;
        }
    }

    public PublicKeyCredential<AuthenticatorAssertionResponse> get(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, CollectedClientData collectedClientData) {
        return this.get(publicKeyCredentialRequestOptions, collectedClientData, new AuthenticationEmulationOption());
    }

    public PublicKeyCredential<AuthenticatorAssertionResponse> get(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions) {
        CollectedClientData collectedClientData = this.createCollectedClientData(ClientDataType.GET, publicKeyCredentialRequestOptions.getChallenge());
        return this.get(publicKeyCredentialRequestOptions, collectedClientData);
    }

    public CollectedClientData createCollectedClientData(ClientDataType type, Challenge challenge) {
        return new CollectedClientData(type, challenge, this.origin, null);
    }

    public CollectedClientData createCollectedClientData(ClientDataType type, Challenge challenge, byte[] tokenBindingId) {
        TokenBinding tokenBinding = new TokenBinding(TokenBindingStatus.PRESENT, tokenBindingId);
        return new CollectedClientData(type, challenge, this.origin, tokenBinding);
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    public AuthenticatorAdaptor getAuthenticatorAdaptor() {
        return this.authenticatorAdaptor;
    }

    public void setAuthenticatorAdaptor(AuthenticatorAdaptor authenticatorAdaptor) {
        this.authenticatorAdaptor = authenticatorAdaptor;
    }
}

