/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.authenticator.u2f;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.request.PublicKeyCredentialCreationOptions;
import com.webauthn4j.request.PublicKeyCredentialDescriptor;
import com.webauthn4j.request.PublicKeyCredentialRequestOptions;
import com.webauthn4j.response.attestation.AttestationObject;
import com.webauthn4j.response.attestation.authenticator.AAGUID;
import com.webauthn4j.response.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.response.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.response.attestation.authenticator.CredentialPublicKey;
import com.webauthn4j.response.attestation.authenticator.EC2CredentialPublicKey;
import com.webauthn4j.response.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.response.attestation.statement.AttestationStatement;
import com.webauthn4j.response.attestation.statement.FIDOU2FAttestationStatement;
import com.webauthn4j.response.client.CollectedClientData;
import com.webauthn4j.test.authenticator.AuthenticatorAdaptor;
import com.webauthn4j.test.authenticator.CredentialCreationResponse;
import com.webauthn4j.test.authenticator.CredentialRequestResponse;
import com.webauthn4j.test.authenticator.u2f.AuthenticationRequest;
import com.webauthn4j.test.authenticator.u2f.AuthenticationResponse;
import com.webauthn4j.test.authenticator.u2f.FIDOU2FAuthenticator;
import com.webauthn4j.test.authenticator.u2f.RegistrationRequest;
import com.webauthn4j.test.authenticator.u2f.RegistrationResponse;
import com.webauthn4j.test.client.AuthenticationEmulationOption;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import com.webauthn4j.util.MessageDigestUtil;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;

public class FIDOU2FAuthenticatorAdaptor
implements AuthenticatorAdaptor {
    private ObjectMapper objectMapper = new ObjectMapper();
    private FIDOU2FAuthenticator fidoU2FAuthenticator = new FIDOU2FAuthenticator();
    private CollectedClientDataConverter collectedClientDataConverter = new CollectedClientDataConverter((ObjectCodec)this.objectMapper);
    private AuthenticatorDataConverter authenticatorDataConverter = new AuthenticatorDataConverter((ObjectCodec)this.objectMapper);

    @Override
    public CredentialCreationResponse register(PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions, CollectedClientData collectedClientData, RegistrationEmulationOption registrationEmulationOption) {
        String rpId = publicKeyCredentialCreationOptions.getRp().getId();
        byte[] rpIdHash = MessageDigestUtil.createSHA256().digest(rpId.getBytes(StandardCharsets.UTF_8));
        byte[] challengeParameter = MessageDigestUtil.createSHA256().digest(this.collectedClientDataConverter.convertToBytes(collectedClientData));
        byte[] applicationParameter = rpIdHash;
        RegistrationRequest registrationRequest = new RegistrationRequest(challengeParameter, applicationParameter);
        RegistrationResponse registrationResponse = this.fidoU2FAuthenticator.register(registrationRequest, registrationEmulationOption);
        FIDOU2FAttestationStatement attestationStatement = new FIDOU2FAttestationStatement(new AttestationCertificatePath(Collections.singletonList(registrationResponse.getAttestationCertificate())), registrationResponse.getSignature());
        EC2CredentialPublicKey ec2CredentialPublicKey = EC2CredentialPublicKey.createFromUncompressedECCKey((byte[])registrationResponse.getUserPublicKey());
        AAGUID aaguid = AAGUID.ZERO;
        AttestedCredentialData attestedCredentialData = new AttestedCredentialData(aaguid, registrationResponse.getKeyHandle(), (CredentialPublicKey)ec2CredentialPublicKey);
        byte flag = 65;
        AuthenticatorData authenticatorData = new AuthenticatorData(rpIdHash, flag, 0L, attestedCredentialData);
        AttestationObject attestationObject = new AttestationObject(authenticatorData, (AttestationStatement)attestationStatement);
        return new CredentialCreationResponse(attestationObject);
    }

    @Override
    public CredentialCreationResponse register(PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions, CollectedClientData collectedClientData) {
        return this.register(publicKeyCredentialCreationOptions, collectedClientData, new RegistrationEmulationOption());
    }

    @Override
    public CredentialRequestResponse authenticate(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, CollectedClientData collectedClientData, AuthenticationEmulationOption authenticationEmulationOption) {
        byte[] collectedClientDataBytes = this.collectedClientDataConverter.convertToBytes(collectedClientData);
        String rpId = publicKeyCredentialRequestOptions.getRpId();
        byte[] rpIdHash = MessageDigestUtil.createSHA256().digest(rpId.getBytes(StandardCharsets.UTF_8));
        byte control = 0;
        byte[] challenge = MessageDigestUtil.createSHA256().digest(collectedClientDataBytes);
        byte[] applicationParameter = rpIdHash;
        List publicKeyCredentialDescriptors = publicKeyCredentialRequestOptions.getAllowCredentials();
        PublicKeyCredentialDescriptor publicKeyCredentialDescriptor = (PublicKeyCredentialDescriptor)publicKeyCredentialDescriptors.get(0);
        byte[] keyHandle = publicKeyCredentialDescriptor.getId();
        AuthenticationRequest authenticationRequest = new AuthenticationRequest(control, challenge, applicationParameter, keyHandle);
        AuthenticationResponse authenticationResponse = this.fidoU2FAuthenticator.authenticate(authenticationRequest, authenticationEmulationOption);
        byte[] credentialId = publicKeyCredentialDescriptor.getId();
        long counter = ByteBuffer.allocate(8).put(new byte[4]).put(authenticationResponse.getCounter()).getLong(0);
        AuthenticatorData authenticatorData = new AuthenticatorData(rpIdHash, authenticationResponse.getUserPresence(), counter);
        byte[] authenticatorDataBytes = this.authenticatorDataConverter.convert(authenticatorData);
        byte[] signature = authenticationResponse.getSignature();
        return new CredentialRequestResponse(credentialId, collectedClientDataBytes, authenticatorDataBytes, signature, null);
    }

    @Override
    public CredentialRequestResponse authenticate(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, CollectedClientData collectedClientData) {
        return this.authenticate(publicKeyCredentialRequestOptions, collectedClientData, new AuthenticationEmulationOption());
    }

    public FIDOU2FAuthenticator getFidoU2FAuthenticator() {
        return this.fidoU2FAuthenticator;
    }
}

