/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.authenticator.webauthn;

import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.PackedAttestationStatement;
import com.webauthn4j.test.AttestationCertificateBuilder;
import com.webauthn4j.test.TestDataUtil;
import com.webauthn4j.test.authenticator.webauthn.AttestationOption;
import com.webauthn4j.test.authenticator.webauthn.AttestationStatementRequest;
import com.webauthn4j.test.authenticator.webauthn.PackedAttestationOption;
import com.webauthn4j.test.authenticator.webauthn.WebAuthnModelAuthenticator;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public class PackedAuthenticator
extends WebAuthnModelAuthenticator {
    @Override
    public AttestationStatement createAttestationStatement(AttestationStatementRequest attestationStatementRequest, RegistrationEmulationOption registrationEmulationOption) {
        byte[] signature = registrationEmulationOption.isSignatureOverrideEnabled() ? registrationEmulationOption.getSignature() : TestDataUtil.calculateSignature(this.getAttestationKeyPair().getPrivate(), attestationStatementRequest.getSignedData());
        AttestationOption attestationOption = registrationEmulationOption.getAttestationOption() == null ? new PackedAttestationOption() : registrationEmulationOption.getAttestationOption();
        X509Certificate attestationCertificate = this.getAttestationCertificate(attestationStatementRequest, attestationOption);
        AttestationCertificatePath attestationCertificatePath = new AttestationCertificatePath(attestationCertificate, (List)this.getCACertificatePath());
        return new PackedAttestationStatement(COSEAlgorithmIdentifier.ES256, signature, attestationCertificatePath);
    }

    @Override
    protected X509Certificate createAttestationCertificate(AttestationStatementRequest attestationStatementRequest, AttestationOption attestationOption) {
        AttestationCertificateBuilder builder = new AttestationCertificateBuilder(this.getAttestationIssuerCertificate(), new X500Principal(attestationOption.getSubjectDN()), this.getAttestationKeyPair().getPublic());
        if (attestationOption.isCAFlagInBasicConstraints()) {
            builder.addBasicConstraintsExtension();
        }
        return builder.build(this.getAttestationIssuerPrivateKey());
    }
}

