/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.webauthn4j.util.AssertUtil;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CACertificatePath
extends AbstractList<X509Certificate> {
    private final int size;
    private final X509Certificate[] certificates;

    @JsonCreator
    public CACertificatePath(List<X509Certificate> certificates) {
        AssertUtil.notNull(certificates, (String)"certificates must not be null");
        this.size = certificates.size();
        this.certificates = certificates.toArray(new X509Certificate[this.size]);
    }

    public CACertificatePath() {
        this(Collections.emptyList());
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public X509Certificate get(int index) {
        return this.certificates[index];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CACertificatePath that = (CACertificatePath)o;
        return this.size == that.size && Arrays.equals(this.certificates, that.certificates);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.size);
        result = 31 * result + Arrays.hashCode(this.certificates);
        return result;
    }
}

