/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.authenticator.webauthn;

import com.webauthn4j.data.attestation.statement.AndroidSafetyNetAttestationStatement;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.Response;
import com.webauthn4j.data.jws.JWAIdentifier;
import com.webauthn4j.data.jws.JWS;
import com.webauthn4j.data.jws.JWSFactory;
import com.webauthn4j.data.jws.JWSHeader;
import com.webauthn4j.test.AttestationCertificateBuilder;
import com.webauthn4j.test.authenticator.webauthn.AndroidSafetyNetAttestationOption;
import com.webauthn4j.test.authenticator.webauthn.AttestationOption;
import com.webauthn4j.test.authenticator.webauthn.AttestationStatementRequest;
import com.webauthn4j.test.authenticator.webauthn.WebAuthnModelAuthenticator;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import com.webauthn4j.util.Base64Util;
import com.webauthn4j.util.CertificateUtil;
import com.webauthn4j.util.MessageDigestUtil;
import java.io.Serializable;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;

public class AndroidSafetyNetAuthenticator
extends WebAuthnModelAuthenticator {
    private JWSFactory jwsFactory;

    @Override
    public AttestationStatement createAttestationStatement(AttestationStatementRequest attestationStatementRequest, RegistrationEmulationOption registrationEmulationOption) {
        AttestationOption attestationOption = registrationEmulationOption.getAttestationOption() == null ? new AndroidSafetyNetAttestationOption() : registrationEmulationOption.getAttestationOption();
        X509Certificate attestationCertificate = this.getAttestationCertificate(attestationStatementRequest, attestationOption);
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        certificates.add(attestationCertificate);
        certificates.addAll(this.getCACertificatePath());
        CertPath certPath = CertificateUtil.generateCertPath(certificates);
        JWSHeader jwsHeader = new JWSHeader(JWAIdentifier.ES256, certPath);
        String nonce = Base64Util.encodeToString((byte[])MessageDigestUtil.createSHA256().digest(attestationStatementRequest.getSignedData()));
        long timestampMs = Instant.now().toEpochMilli();
        String apkPackageName = "com.android.keystore.androidkeystoredemo";
        String[] apkCertificateDigestSha256 = new String[]{"bsb4/WQdaaOWYCd/j9OJiQpg7b0iwFgAc/zzA1tCfwE="};
        String apkDigestSha256 = "dM/LUHSI9SkQhZHHpQWRnzJ3MvvB2ANSauqYAAbS2Jg=";
        boolean ctsProfileMatch = true;
        boolean basicIntegrity = true;
        String advice = null;
        Response response = new Response(nonce, Long.valueOf(timestampMs), apkPackageName, apkCertificateDigestSha256, apkDigestSha256, Boolean.valueOf(ctsProfileMatch), Boolean.valueOf(basicIntegrity), advice);
        String ver = "12685023";
        JWS jws = this.getJwsFactory().create(jwsHeader, (Serializable)response, this.getAttestationKeyPair().getPrivate());
        if (registrationEmulationOption.isSignatureOverrideEnabled()) {
            jws = this.getJwsFactory().create(jws.getHeader(), jws.getPayload(), registrationEmulationOption.getSignature());
        }
        return new AndroidSafetyNetAttestationStatement(ver, jws);
    }

    @Override
    X509Certificate createAttestationCertificate(AttestationStatementRequest attestationStatementRequest, AttestationOption attestationOption) {
        AttestationCertificateBuilder builder = new AttestationCertificateBuilder(this.getAttestationIssuerCertificate(), new X500Principal(attestationOption.getSubjectDN()), this.getAttestationKeyPair().getPublic());
        builder.addBasicConstraintsExtension();
        builder.addKeyUsageExtension();
        return builder.build(this.getAttestationIssuerPrivateKey());
    }

    private JWSFactory getJwsFactory() {
        if (this.jwsFactory == null) {
            this.jwsFactory = new JWSFactory(this.objectConverter);
        }
        return this.jwsFactory;
    }
}

