/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.authenticator.webauthn;

import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.PublicKeyCredentialCreationOptions;
import com.webauthn4j.data.PublicKeyCredentialRequestOptions;
import com.webauthn4j.data.UserVerificationRequirement;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientInput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientInput;
import com.webauthn4j.test.authenticator.AuthenticatorAdaptor;
import com.webauthn4j.test.authenticator.CredentialCreationResponse;
import com.webauthn4j.test.authenticator.CredentialRequestResponse;
import com.webauthn4j.test.authenticator.webauthn.AttestationOption;
import com.webauthn4j.test.authenticator.webauthn.GetAssertionRequest;
import com.webauthn4j.test.authenticator.webauthn.GetAssertionResponse;
import com.webauthn4j.test.authenticator.webauthn.MakeCredentialRequest;
import com.webauthn4j.test.authenticator.webauthn.MakeCredentialResponse;
import com.webauthn4j.test.authenticator.webauthn.WebAuthnAuthenticator;
import com.webauthn4j.test.client.AuthenticationEmulationOption;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.util.exception.NotImplementedException;

public class WebAuthnAuthenticatorAdaptor
implements AuthenticatorAdaptor {
    private final WebAuthnAuthenticator webAuthnAuthenticator;
    private final CollectedClientDataConverter collectedClientDataConverter;

    public WebAuthnAuthenticatorAdaptor(WebAuthnAuthenticator webAuthnAuthenticator, ObjectConverter objectConverter) {
        this.webAuthnAuthenticator = webAuthnAuthenticator;
        this.collectedClientDataConverter = new CollectedClientDataConverter(objectConverter);
    }

    public WebAuthnAuthenticatorAdaptor(WebAuthnAuthenticator webAuthnAuthenticator) {
        this(webAuthnAuthenticator, new ObjectConverter());
    }

    @Override
    public CredentialCreationResponse register(PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions, CollectedClientData collectedClientData, RegistrationEmulationOption registrationEmulationOption, AttestationOption attestationOption) {
        boolean effectiveResidentKeyRequirement;
        byte[] collectedClientDataBytes = this.collectedClientDataConverter.convertToBytes(collectedClientData);
        byte[] clientDataHash = MessageDigestUtil.createSHA256().digest(collectedClientDataBytes);
        if (publicKeyCredentialCreationOptions.getAuthenticatorSelection().getResidentKey() == null) {
            Boolean requireResidentKey = publicKeyCredentialCreationOptions.getAuthenticatorSelection().isRequireResidentKey();
            effectiveResidentKeyRequirement = requireResidentKey == null ? false : requireResidentKey;
        } else {
            switch (publicKeyCredentialCreationOptions.getAuthenticatorSelection().getResidentKey()) {
                case REQUIRED: {
                    effectiveResidentKeyRequirement = true;
                    break;
                }
                case PREFERRED: {
                    effectiveResidentKeyRequirement = this.webAuthnAuthenticator.isCapableOfStoringClientSideResidentCredential();
                    break;
                }
                case DISCOURAGED: {
                    effectiveResidentKeyRequirement = false;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        boolean requireUserVerification = this.getEffectiveUserVerificationRequirementForAssertion(publicKeyCredentialCreationOptions.getAuthenticatorSelection().getUserVerification());
        MakeCredentialRequest makeCredentialRequest = new MakeCredentialRequest(clientDataHash, publicKeyCredentialCreationOptions.getRp(), publicKeyCredentialCreationOptions.getUser(), effectiveResidentKeyRequirement, true, requireUserVerification, publicKeyCredentialCreationOptions.getPubKeyCredParams(), publicKeyCredentialCreationOptions.getExcludeCredentials(), (AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput>)publicKeyCredentialCreationOptions.getExtensions());
        MakeCredentialResponse makeCredentialResponse = this.webAuthnAuthenticator.makeCredential(makeCredentialRequest, registrationEmulationOption);
        return new CredentialCreationResponse(makeCredentialResponse.getAttestationObject());
    }

    @Override
    public CredentialCreationResponse register(PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions, CollectedClientData collectedClientData) {
        return this.register(publicKeyCredentialCreationOptions, collectedClientData, new RegistrationEmulationOption(), null);
    }

    @Override
    public CredentialRequestResponse authenticate(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, CollectedClientData collectedClientData) {
        return this.authenticate(publicKeyCredentialRequestOptions, collectedClientData, new AuthenticationEmulationOption());
    }

    @Override
    public CredentialRequestResponse authenticate(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, CollectedClientData collectedClientData, AuthenticationEmulationOption authenticationEmulationOption) {
        byte[] collectedClientDataBytes = this.collectedClientDataConverter.convertToBytes(collectedClientData);
        byte[] clientDataHash = MessageDigestUtil.createSHA256().digest(collectedClientDataBytes);
        boolean requireUserVerification = this.getEffectiveUserVerificationRequirementForAssertion(publicKeyCredentialRequestOptions.getUserVerification());
        GetAssertionRequest getAssertionRequest = new GetAssertionRequest(publicKeyCredentialRequestOptions.getRpId(), clientDataHash, publicKeyCredentialRequestOptions.getAllowCredentials(), true, requireUserVerification, (AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput>)publicKeyCredentialRequestOptions.getExtensions());
        GetAssertionResponse getAssertionResponse = this.webAuthnAuthenticator.getAssertion(getAssertionRequest, authenticationEmulationOption);
        return new CredentialRequestResponse(getAssertionResponse.getCredentialId(), collectedClientDataBytes, getAssertionResponse.getAuthenticatorData(), getAssertionResponse.getSignature(), getAssertionResponse.getUserHandle());
    }

    private boolean getEffectiveUserVerificationRequirementForAssertion(UserVerificationRequirement userVerificationRequirement) {
        switch (userVerificationRequirement) {
            case REQUIRED: {
                return true;
            }
            case PREFERRED: {
                return this.webAuthnAuthenticator.isCapableOfUserVerification();
            }
            case DISCOURAGED: {
                return false;
            }
        }
        throw new NotImplementedException();
    }
}

