/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test;

import com.webauthn4j.data.attestation.statement.AndroidKeyAttestationStatement;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.FIDOU2FAttestationStatement;
import com.webauthn4j.data.attestation.statement.PackedAttestationStatement;
import com.webauthn4j.test.TestAttestationUtil;

public class TestAttestationStatementUtil {
    private TestAttestationStatementUtil() {
    }

    public static FIDOU2FAttestationStatement createFIDOU2FAttestationStatement() {
        return TestAttestationStatementUtil.createFIDOU2FAttestationStatement(TestAttestationUtil.load2tierTestAttestationCertificatePath());
    }

    public static FIDOU2FAttestationStatement createFIDOU2FAttestationStatement(AttestationCertificatePath certPath) {
        byte[] sig = new byte[32];
        return new FIDOU2FAttestationStatement(certPath, sig);
    }

    public static PackedAttestationStatement createBasicPackedAttestationStatement() {
        byte[] signature = new byte[32];
        return TestAttestationStatementUtil.createBasicPackedAttestationStatement(COSEAlgorithmIdentifier.ES256, signature);
    }

    public static PackedAttestationStatement createBasicPackedAttestationStatement(COSEAlgorithmIdentifier algorithm, byte[] signature) {
        AttestationCertificatePath certPath = TestAttestationUtil.load3tierTestAttestationCertificatePath();
        return new PackedAttestationStatement(algorithm, signature, certPath);
    }

    public static PackedAttestationStatement createSelfPackedAttestationStatement(COSEAlgorithmIdentifier algorithm, byte[] signature) {
        return new PackedAttestationStatement(algorithm, signature, null);
    }

    public static AndroidKeyAttestationStatement createAndroidKeyAttestationStatement(COSEAlgorithmIdentifier algorithm, byte[] signature) {
        AttestationCertificatePath certPath = TestAttestationUtil.load3tierTestAttestationCertificatePath();
        return new AndroidKeyAttestationStatement(algorithm, signature, certPath);
    }
}

