/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.authenticator.u2f;

import com.webauthn4j.test.TestConstants;
import com.webauthn4j.test.authenticator.u2f.AuthenticationRequest;
import com.webauthn4j.test.authenticator.u2f.AuthenticationResponse;
import com.webauthn4j.test.authenticator.u2f.RegistrationRequest;
import com.webauthn4j.test.authenticator.u2f.RegistrationResponse;
import com.webauthn4j.test.authenticator.u2f.exception.FIDOU2FException;
import com.webauthn4j.test.client.AuthenticationEmulationOption;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.ECUtil;
import com.webauthn4j.util.MACUtil;
import com.webauthn4j.util.SignatureUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.util.Arrays;

public class FIDOU2FAuthenticator {
    public static final byte FLAG_OFF = 0;
    public static final byte FLAG_UP = 1;
    private static final SecureRandom secureRandom = new SecureRandom();
    private final PrivateKey attestationPrivateKey;
    private final X509Certificate attestationPublicKeyCertificate;
    private long counter;
    private byte flags = 1;
    private boolean countUpEnabled = true;

    public FIDOU2FAuthenticator(PrivateKey attestationPrivateKey, X509Certificate attestationPublicKeyCertificate, int counter) {
        AssertUtil.notNull((Object)attestationPrivateKey, (String)"attestationPrivateKey must not be null");
        AssertUtil.notNull((Object)attestationPublicKeyCertificate, (String)"attestationPublicKeyCertificate must not be null");
        this.attestationPrivateKey = attestationPrivateKey;
        this.attestationPublicKeyCertificate = attestationPublicKeyCertificate;
        this.counter = counter;
    }

    public FIDOU2FAuthenticator() {
        this(TestConstants.GENERIC_2TIER_ATTESTATION_PRIVATE_KEY, TestConstants.GENERIC_2TIER_ATTESTATION_CERTIFICATE, 0);
    }

    public RegistrationResponse register(RegistrationRequest registrationRequest, RegistrationEmulationOption registrationEmulationOption) {
        byte[] challengeParameter = registrationRequest.getChallengeParameter();
        byte[] applicationParameter = registrationRequest.getApplicationParameter();
        byte[] nonce = new byte[32];
        secureRandom.nextBytes(nonce);
        KeyPair keyPair = this.getKeyPair(applicationParameter, nonce);
        byte[] rpPrivateKey = keyPair.getPrivate().getEncoded();
        byte[] message = ByteBuffer.allocate(32 + rpPrivateKey.length).put(applicationParameter).put(rpPrivateKey).array();
        byte[] mac = MACUtil.calculateHmacSHA256((byte[])message, (byte[])this.attestationPrivateKey.getEncoded());
        byte[] keyHandle = ByteBuffer.allocate(64).put(nonce).put(mac).array();
        byte[] userPublicKey = this.getBytesFromECPublicKey((ECPublicKey)keyPair.getPublic());
        byte rfu = 0;
        byte[] signedData = ByteBuffer.allocate(65 + keyHandle.length + 65).put(rfu).put(applicationParameter).put(challengeParameter).put(keyHandle).put(userPublicKey).array();
        byte[] signature = registrationEmulationOption.isSignatureOverrideEnabled() ? registrationEmulationOption.getSignature() : this.calculateSignature(this.attestationPrivateKey, signedData);
        return new RegistrationResponse(userPublicKey, keyHandle, this.attestationPublicKeyCertificate, signature);
    }

    public RegistrationResponse register(RegistrationRequest registrationRequest) {
        return this.register(registrationRequest, new RegistrationEmulationOption());
    }

    public AuthenticationResponse authenticate(AuthenticationRequest authenticationRequest, AuthenticationEmulationOption authenticationEmulationOption) {
        byte control = authenticationRequest.getControl();
        byte[] applicationParameter = authenticationRequest.getApplicationParameter();
        byte[] challenge = authenticationRequest.getChallenge();
        byte[] keyHandle = authenticationRequest.getKeyHandle();
        byte[] nonce = Arrays.copyOf(keyHandle, 32);
        KeyPair keyPair = this.getKeyPair(applicationParameter, nonce);
        this.countUp();
        byte[] signedData = ByteBuffer.allocate(69).put(applicationParameter).put(this.flags).put(this.getCounterBytes()).put(challenge).array();
        byte[] signature = this.calculateSignature(keyPair.getPrivate(), signedData);
        return new AuthenticationResponse(this.flags, this.getCounterBytes(), signature);
    }

    public AuthenticationResponse authenticate(AuthenticationRequest authenticationRequest) {
        return this.authenticate(authenticationRequest, new AuthenticationEmulationOption());
    }

    private byte[] getBytesFromECPublicKey(ECPublicKey ecPublicKey) {
        ECPoint ecPoint = ecPublicKey.getW();
        byte type = 4;
        byte[] x = ecPoint.getAffineX().toByteArray();
        byte[] y = ecPoint.getAffineY().toByteArray();
        x = Arrays.copyOfRange(x, Math.max(0, x.length - 32), x.length);
        y = Arrays.copyOfRange(y, Math.max(0, y.length - 32), y.length);
        ByteBuffer byteBuffer = ByteBuffer.allocate(65);
        byteBuffer.put(type);
        byteBuffer.position(byteBuffer.position() + 32 - x.length);
        byteBuffer.put(x);
        byteBuffer.position(byteBuffer.position() + 32 - y.length);
        byteBuffer.put(y);
        return byteBuffer.array();
    }

    private KeyPair getKeyPair(byte[] applicationParameter, byte[] nonce) {
        byte[] seed = ByteBuffer.allocate(64).put(applicationParameter).put(nonce).array();
        return ECUtil.createKeyPair((byte[])seed);
    }

    private byte[] calculateSignature(PrivateKey privateKey, byte[] signedData) {
        try {
            Signature signature = SignatureUtil.getES256();
            signature.initSign(privateKey);
            signature.update(signedData);
            return signature.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new FIDOU2FException("Signature calculation error", e);
        }
    }

    private void countUp() {
        if (this.isCountUpEnabled()) {
            ++this.counter;
        }
    }

    private byte[] getCounterBytes() {
        return UnsignedNumberUtil.toBytes((long)this.counter);
    }

    public boolean isCountUpEnabled() {
        return this.countUpEnabled;
    }

    public void setCountUpEnabled(boolean countUpEnabled) {
        this.countUpEnabled = countUpEnabled;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }
}

