/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.metadata.MetadataItemsProvider;
import com.webauthn4j.metadata.data.MetadataItem;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatingMetadataItemsProvider
implements MetadataItemsProvider {
    private Logger logger = LoggerFactory.getLogger(AggregatingMetadataItemsProvider.class);
    private List<MetadataItemsProvider> metadataItemsProviders;

    public AggregatingMetadataItemsProvider(List<MetadataItemsProvider> metadataItemsProviders) {
        this.metadataItemsProviders = metadataItemsProviders;
    }

    @Override
    public Map<AAGUID, Set<MetadataItem>> provide() {
        return this.metadataItemsProviders.stream().flatMap(provider -> {
            try {
                return provider.provide().entrySet().stream();
            }
            catch (RuntimeException e) {
                this.logger.warn("Failed to load metadata from one of metadataItemsProviders", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

