/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum KeyProtection {
    SOFTWARE(1),
    HARDWARE(2),
    TEE(4),
    SECURE_ELEMENT(8),
    REMOTE_HANDLE(16);

    private final int value;

    private KeyProtection(int value) {
        this.value = value;
    }

    public static KeyProtection create(int value) {
        if (value > 65535 || value < 0) {
            throw new IllegalArgumentException("value '" + value + "' is out of range");
        }
        switch (value) {
            case 1: {
                return SOFTWARE;
            }
            case 2: {
                return HARDWARE;
            }
            case 4: {
                return TEE;
            }
            case 8: {
                return SECURE_ELEMENT;
            }
            case 16: {
                return REMOTE_HANDLE;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static KeyProtection fromJson(int value) throws InvalidFormatException {
        try {
            return KeyProtection.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, KeyProtection.class);
        }
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }
}

