/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.anchor;

import com.webauthn4j.anchor.TrustAnchorRepository;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.metadata.LocalFilesMetadataStatementsProvider;
import com.webauthn4j.metadata.MetadataStatementsProvider;
import com.webauthn4j.util.HexUtil;
import java.nio.file.Path;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class MetadataStatementsBasedTrustAnchorRepository
implements TrustAnchorRepository {
    private final MetadataStatementsProvider metadataStatementsProvider;

    public MetadataStatementsBasedTrustAnchorRepository(MetadataStatementsProvider metadataStatementsProvider) {
        this.metadataStatementsProvider = metadataStatementsProvider;
    }

    public MetadataStatementsBasedTrustAnchorRepository(ObjectConverter objectConverter, Path ... paths) {
        this(new LocalFilesMetadataStatementsProvider(objectConverter, paths));
    }

    public Set<TrustAnchor> find(AAGUID aaguid) {
        return this.metadataStatementsProvider.provide().stream().filter(metadataStatement -> Objects.equals(aaguid, metadataStatement.getAaguid())).flatMap(metadataStatement -> metadataStatement.getAttestationRootCertificates().stream()).map(item -> new TrustAnchor((X509Certificate)item, null)).collect(Collectors.toSet());
    }

    public Set<TrustAnchor> find(byte[] attestationCertificateKeyIdentifier) {
        return this.metadataStatementsProvider.provide().stream().filter(metadataStatement -> metadataStatement.getAttestationCertificateKeyIdentifiers() != null && metadataStatement.getAttestationCertificateKeyIdentifiers().stream().anyMatch(identifier -> Arrays.equals(HexUtil.decode((String)identifier), attestationCertificateKeyIdentifier))).map(metadataStatement -> new TrustAnchor(metadataStatement.getAttestationRootCertificates().get(0), null)).collect(Collectors.toSet());
    }
}

