/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.validator;

import com.webauthn4j.metadata.data.statement.MetadataStatement;
import com.webauthn4j.metadata.exception.UnknownProtocolFamilyException;
import java.util.Arrays;
import java.util.List;

public class MetadataStatementValidator {
    private final List<String> KNOWN_PROTOCOL_FAMILY = Arrays.asList("uaf", "u2f", "fido2");
    private final List<String> KNOWN_ASSERTION_SCHEME = Arrays.asList("FIDOV2", "U2FV1BIN", "UAFV1TLV");

    public void validate(MetadataStatement metadataStatement) {
        this.validateProtocolFamily(metadataStatement.getProtocolFamily());
        this.validateAssertionScheme(metadataStatement.getAssertionScheme());
    }

    private void validateProtocolFamily(String protocolFamily) {
        if (!this.KNOWN_PROTOCOL_FAMILY.contains(protocolFamily)) {
            throw new UnknownProtocolFamilyException(String.format("Unknown protocol family '%s' is provided", protocolFamily));
        }
    }

    private void validateAssertionScheme(String assertionScheme) {
        if (!this.KNOWN_ASSERTION_SCHEME.contains(assertionScheme)) {
            throw new UnknownProtocolFamilyException(String.format("Unknown assertion scheme '%s' is provided", assertionScheme));
        }
    }
}

