/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.metadata.MetadataStatementsProvider;
import com.webauthn4j.metadata.data.statement.MetadataStatement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatingMetadataStatementsProvider
implements MetadataStatementsProvider {
    private final Logger logger = LoggerFactory.getLogger(AggregatingMetadataStatementsProvider.class);
    private final List<MetadataStatementsProvider> metadataStatementsProviders;

    public AggregatingMetadataStatementsProvider(List<MetadataStatementsProvider> metadataStatementsProviders) {
        this.metadataStatementsProviders = metadataStatementsProviders;
    }

    @Override
    public Map<AAGUID, Set<MetadataStatement>> provide() {
        return this.metadataStatementsProviders.stream().flatMap(provider -> {
            try {
                return provider.provide().entrySet().stream();
            }
            catch (RuntimeException e) {
                this.logger.warn("Failed to load metadata from one of metadataStatementsProviders", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

