/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum UserVerificationMethod {
    PRESENCE(1L),
    FINGERPRINT(2L),
    PASSCODE(4L),
    VOICEPRINT(8L),
    FACEPRINT(16L),
    LOCATION(32L),
    EYEPRINT(64L),
    PATTERN(128L),
    HANDPRINT(256L),
    NONE(512L),
    ALL(1024L);

    private final long value;

    private UserVerificationMethod(long value) {
        this.value = value;
    }

    public static UserVerificationMethod create(long value) {
        if (value == 1L) {
            return PRESENCE;
        }
        if (value == 2L) {
            return FINGERPRINT;
        }
        if (value == 4L) {
            return PASSCODE;
        }
        if (value == 8L) {
            return VOICEPRINT;
        }
        if (value == 16L) {
            return FACEPRINT;
        }
        if (value == 32L) {
            return LOCATION;
        }
        if (value == 64L) {
            return EYEPRINT;
        }
        if (value == 128L) {
            return PATTERN;
        }
        if (value == 256L) {
            return HANDPRINT;
        }
        if (value == 512L) {
            return NONE;
        }
        if (value == 1024L) {
            return ALL;
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static UserVerificationMethod deserialize(long value) throws InvalidFormatException {
        try {
            return UserVerificationMethod.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, UserVerificationMethod.class);
        }
    }

    @JsonValue
    public long getValue() {
        return this.value;
    }
}

