/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.jws.JWS;
import com.webauthn4j.data.jws.JWSFactory;
import com.webauthn4j.metadata.HttpClient;
import com.webauthn4j.metadata.MetadataItemsProvider;
import com.webauthn4j.metadata.SimpleHttpClient;
import com.webauthn4j.metadata.data.MetadataItem;
import com.webauthn4j.metadata.data.MetadataItemImpl;
import com.webauthn4j.metadata.data.statement.MetadataStatement;
import com.webauthn4j.metadata.data.toc.MetadataTOCPayload;
import com.webauthn4j.metadata.data.toc.MetadataTOCPayloadEntry;
import com.webauthn4j.metadata.exception.MDSException;
import com.webauthn4j.metadata.validator.MetadataStatementValidator;
import com.webauthn4j.util.Base64UrlUtil;
import com.webauthn4j.util.CertificateUtil;
import com.webauthn4j.util.MessageDigestUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FidoMdsMetadataItemsProvider
implements MetadataItemsProvider {
    private static final String DEFAULT_FIDO_METADATA_SERVICE_ENDPOINT = "https://mds2.fidoalliance.org/";
    private Logger logger = LoggerFactory.getLogger(FidoMdsMetadataItemsProvider.class);
    Map<AAGUID, Set<MetadataItem>> cachedMetadataItemMap;
    OffsetDateTime nextUpdate;
    OffsetDateTime lastRefresh;
    private JsonConverter jsonConverter;
    private JWSFactory jwsFactory;
    private HttpClient httpClient;
    private String fidoMetadataServiceEndpoint = "https://mds2.fidoalliance.org/";
    private TrustAnchor trustAnchor;
    private MetadataStatementValidator metadataStatementValidator = new MetadataStatementValidator();

    public FidoMdsMetadataItemsProvider(ObjectConverter objectConverter, HttpClient httpClient, X509Certificate rootCertificate) {
        this.jsonConverter = objectConverter.getJsonConverter();
        this.jwsFactory = new JWSFactory(objectConverter);
        this.httpClient = httpClient;
        this.trustAnchor = new TrustAnchor(rootCertificate, null);
    }

    public FidoMdsMetadataItemsProvider(ObjectConverter objectConverter, HttpClient httpClient, Path path) {
        this(objectConverter, httpClient, FidoMdsMetadataItemsProvider.loadRootCertificateFromPath(path));
    }

    public FidoMdsMetadataItemsProvider(ObjectConverter objectConverter, HttpClient httpClient) {
        this(objectConverter, httpClient, FidoMdsMetadataItemsProvider.loadEmbeddedFidoMdsRootCertificate());
    }

    public FidoMdsMetadataItemsProvider(ObjectConverter objectConverter) {
        this(objectConverter, (HttpClient)new SimpleHttpClient(), FidoMdsMetadataItemsProvider.loadEmbeddedFidoMdsRootCertificate());
    }

    @Deprecated
    public FidoMdsMetadataItemsProvider(JsonConverter jsonConverter, HttpClient httpClient, X509Certificate rootCertificate) {
        this.jsonConverter = jsonConverter;
        this.jwsFactory = new JWSFactory(jsonConverter);
        this.httpClient = httpClient;
        this.trustAnchor = new TrustAnchor(rootCertificate, null);
    }

    @Deprecated
    public FidoMdsMetadataItemsProvider(JsonConverter jsonConverter, HttpClient httpClient, Path path) {
        this(jsonConverter, httpClient, FidoMdsMetadataItemsProvider.loadRootCertificateFromPath(path));
    }

    @Deprecated
    public FidoMdsMetadataItemsProvider(JsonConverter jsonConverter, HttpClient httpClient) {
        this(jsonConverter, httpClient, FidoMdsMetadataItemsProvider.loadEmbeddedFidoMdsRootCertificate());
    }

    @Deprecated
    public FidoMdsMetadataItemsProvider(JsonConverter jsonConverter) {
        this(jsonConverter, (HttpClient)new SimpleHttpClient(), FidoMdsMetadataItemsProvider.loadEmbeddedFidoMdsRootCertificate());
    }

    private static X509Certificate loadRootCertificateFromPath(Path path) {
        try {
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            return CertificateUtil.generateX509Certificate((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static X509Certificate loadEmbeddedFidoMdsRootCertificate() {
        InputStream inputStream = FidoMdsMetadataItemsProvider.class.getClassLoader().getResourceAsStream("metadata/certs/FIDOMetadataService.cer");
        return CertificateUtil.generateX509Certificate((InputStream)inputStream);
    }

    @Override
    public Map<AAGUID, Set<MetadataItem>> provide() {
        if (this.needsRefresh()) {
            this.refresh();
        }
        return this.cachedMetadataItemMap;
    }

    public String getFidoMetadataServiceEndpoint() {
        return this.fidoMetadataServiceEndpoint;
    }

    public void setFidoMetadataServiceEndpoint(String fidoMetadataServiceEndpoint) {
        this.fidoMetadataServiceEndpoint = fidoMetadataServiceEndpoint;
    }

    private void refresh() {
        MetadataTOCPayload tocPayload = this.fetchMetadataTOCPayload(false);
        this.cachedMetadataItemMap = tocPayload.getEntries().parallelStream().map(entry -> {
            try {
                return this.fetchFidoMdsMetadataItem((MetadataTOCPayloadEntry)entry);
            }
            catch (RuntimeException e) {
                this.logger.warn("Failed to fetch MetadataTOCPayLoad", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).distinct().collect(Collectors.groupingBy(item -> item.getMetadataStatement().getAaguid())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.unmodifiableSet(new HashSet((Collection)entry.getValue()))));
        this.nextUpdate = tocPayload.getNextUpdate().atStartOfDay().atOffset(ZoneOffset.UTC);
        this.lastRefresh = OffsetDateTime.now(ZoneOffset.UTC);
    }

    boolean needsRefresh() {
        OffsetDateTime now = OffsetDateTime.now(ZoneOffset.UTC);
        return this.cachedMetadataItemMap == null || this.nextUpdate.isBefore(now) && this.lastRefresh.isBefore(now.minusHours(1L));
    }

    MetadataTOCPayload fetchMetadataTOCPayload(boolean skipCertPathValidation) {
        String url = this.fidoMetadataServiceEndpoint;
        String toc = this.httpClient.fetch(url);
        JWS jws = this.jwsFactory.parse(toc, MetadataTOCPayload.class);
        if (!jws.isValidSignature()) {
            throw new MDSException("invalid signature");
        }
        if (!skipCertPathValidation) {
            this.validateCertPath((JWS<MetadataTOCPayload>)jws);
        }
        return (MetadataTOCPayload)jws.getPayload();
    }

    private MetadataItem fetchFidoMdsMetadataItem(MetadataTOCPayloadEntry entry) {
        MetadataStatement metadataStatement = this.fetchMetadataStatement(entry.getUrl().toString(), Base64UrlUtil.decode((String)entry.getHash()));
        return new MetadataItemImpl(entry.getAaid(), new AAGUID(entry.getAaguid()), entry.getAttestationCertificateKeyIdentifiers(), entry.getHash(), entry.getStatusReports(), entry.getTimeOfLastStatusChange(), metadataStatement);
    }

    private void validateCertPath(JWS<MetadataTOCPayload> jws) {
        Set<TrustAnchor> trustAnchors = Collections.singleton(this.trustAnchor);
        CertPath certPath = jws.getHeader().getX5c().createCertPath();
        CertPathValidator certPathValidator = CertificateUtil.createCertPathValidator();
        PKIXParameters certPathParameters = CertificateUtil.createPKIXParameters(trustAnchors);
        PKIXRevocationChecker pkixRevocationChecker = (PKIXRevocationChecker)certPathValidator.getRevocationChecker();
        pkixRevocationChecker.setOptions(EnumSet.of(PKIXRevocationChecker.Option.PREFER_CRLS));
        certPathParameters.addCertPathChecker(pkixRevocationChecker);
        try {
            certPathValidator.validate(certPath, certPathParameters);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MDSException("invalid algorithm parameter", e);
        }
        catch (CertPathValidatorException e) {
            throw new MDSException("invalid cert path", e);
        }
    }

    MetadataStatement fetchMetadataStatement(String uri, byte[] expectedHash) {
        String metadataStatementBase64url = this.httpClient.fetch(uri);
        String metadataStatementStr = new String(Base64UrlUtil.decode((String)metadataStatementBase64url));
        byte[] hash = MessageDigestUtil.createSHA256().digest(metadataStatementBase64url.getBytes(StandardCharsets.UTF_8));
        if (!Arrays.equals(hash, expectedHash)) {
            throw new MDSException("Hash of metadataStatement doesn't match");
        }
        MetadataStatement metadataStatement = (MetadataStatement)this.jsonConverter.readValue(metadataStatementStr, MetadataStatement.class);
        this.metadataStatementValidator.validate(metadataStatement);
        return metadataStatement;
    }
}

