/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.util.ECUtil;
import java.security.spec.ECParameterSpec;

public enum Curve {
    SECP256R1(1),
    SECP384R1(2),
    SECP521R1(3);

    private final int value;

    private Curve(int value) {
        this.value = value;
    }

    public static Curve create(int value) {
        switch (value) {
            case 1: {
                return SECP256R1;
            }
            case 2: {
                return SECP384R1;
            }
            case 3: {
                return SECP521R1;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    static Curve deserialize(int value) throws InvalidFormatException {
        try {
            return Curve.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, Curve.class);
        }
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }

    public ECParameterSpec getECParameterSpec() {
        switch (this.value) {
            case 1: {
                return ECUtil.P_256_SPEC;
            }
            case 2: {
                return ECUtil.P_384_SPEC;
            }
            case 3: {
                return ECUtil.P_521_SPEC;
            }
        }
        throw new IllegalStateException();
    }
}

