/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.attestation.authenticator.CredentialPublicKey;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.COSEKeyOperation;
import com.webauthn4j.data.attestation.statement.COSEKeyType;
import com.webauthn4j.util.ArrayUtil;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class AbstractCredentialPublicKey
implements CredentialPublicKey {
    @JsonProperty(value="2")
    private byte[] keyId;
    @JsonProperty(value="3")
    private COSEAlgorithmIdentifier algorithm;
    @JsonProperty(value="4")
    private List<COSEKeyOperation> keyOpts;
    @JsonProperty(value="5")
    private byte[] baseIV;

    @JsonCreator
    AbstractCredentialPublicKey(@JsonProperty(value="2") byte[] keyId, @JsonProperty(value="3") COSEAlgorithmIdentifier algorithm, @JsonProperty(value="4") List<COSEKeyOperation> keyOpts, @JsonProperty(value="5") byte[] baseIV) {
        this.keyId = keyId;
        this.algorithm = algorithm;
        this.keyOpts = keyOpts;
        this.baseIV = baseIV;
    }

    @Override
    @JsonProperty(value="1")
    public abstract COSEKeyType getKeyType();

    @Override
    public byte[] getKeyId() {
        return ArrayUtil.clone((byte[])this.keyId);
    }

    @Override
    public COSEAlgorithmIdentifier getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public List<COSEKeyOperation> getKeyOpts() {
        return this.keyOpts;
    }

    @Override
    public byte[] getBaseIV() {
        return ArrayUtil.clone((byte[])this.baseIV);
    }

    @JsonIgnore
    private String getAlgorithmName() {
        return this.algorithm.getJcaName();
    }

    @Override
    public boolean verifySignature(byte[] signature, byte[] data) {
        try {
            Signature verifier = Signature.getInstance(this.getAlgorithmName());
            verifier.initVerify(this.getPublicKey());
            verifier.update(data);
            return verifier.verify(signature);
        }
        catch (RuntimeException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCredentialPublicKey that = (AbstractCredentialPublicKey)o;
        return Arrays.equals(this.keyId, that.keyId) && this.algorithm == that.algorithm && Objects.equals(this.keyOpts, that.keyOpts) && Arrays.equals(this.baseIV, that.baseIV);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.algorithm, this.keyOpts});
        result = 31 * result + Arrays.hashCode(this.keyId);
        result = 31 * result + Arrays.hashCode(this.baseIV);
        return result;
    }
}

