/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum TokenBindingStatus {
    PRESENT("present"),
    SUPPORTED("supported"),
    NOT_SUPPORTED("not-supported");

    private final String value;

    private TokenBindingStatus(String value) {
        this.value = value;
    }

    public static TokenBindingStatus create(String value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "present": {
                return PRESENT;
            }
            case "supported": {
                return SUPPORTED;
            }
            case "not-supported": {
                return NOT_SUPPORTED;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static TokenBindingStatus fromJson(String value) throws InvalidFormatException {
        try {
            return TokenBindingStatus.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, TokenBindingStatus.class);
        }
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }
}

