/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum TPMIAlgHash {
    TPM_ALG_ERROR(0),
    TPM_ALG_SHA1(4),
    TPM_ALG_SHA256(11),
    TPM_ALG_SHA384(12),
    TPM_ALG_SHA512(13),
    TPM_ALG_NULL(16);

    private final int value;

    private TPMIAlgHash(int value) {
        this.value = value;
    }

    public static TPMIAlgHash create(int value) {
        if (value == TPMIAlgHash.TPM_ALG_ERROR.value) {
            return TPM_ALG_ERROR;
        }
        if (value == TPMIAlgHash.TPM_ALG_SHA1.value) {
            return TPM_ALG_SHA1;
        }
        if (value == TPMIAlgHash.TPM_ALG_SHA256.value) {
            return TPM_ALG_SHA256;
        }
        if (value == TPMIAlgHash.TPM_ALG_SHA384.value) {
            return TPM_ALG_SHA384;
        }
        if (value == TPMIAlgHash.TPM_ALG_SHA512.value) {
            return TPM_ALG_SHA512;
        }
        if (value == TPMIAlgHash.TPM_ALG_NULL.value) {
            return TPM_ALG_NULL;
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static TPMIAlgHash fromJson(int value) throws InvalidFormatException {
        try {
            return TPMIAlgHash.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, TPMIAlgHash.class);
        }
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }
}

