/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.exception.BadChallengeException;
import com.webauthn4j.validator.exception.MissingChallengeException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChallengeValidator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    ChallengeValidator() {
    }

    public void validate(CollectedClientData collectedClientData, ServerProperty serverProperty) {
        AssertUtil.notNull((Object)collectedClientData, (String)"collectedClientData must not be null");
        AssertUtil.notNull((Object)serverProperty, (String)"serverProperty must not be null");
        Challenge savedChallenge = serverProperty.getChallenge();
        Challenge collectedChallenge = collectedClientData.getChallenge();
        if (savedChallenge == null) {
            this.logger.debug("Authentication failed: challenge is not found in the relying party");
            throw new MissingChallengeException("`challenge` doesn't exist in collectedClientData.");
        }
        this.validate(savedChallenge, collectedChallenge);
    }

    public void validate(Challenge expected, Challenge actual) {
        AssertUtil.notNull((Object)expected, (String)"expected must not be null");
        AssertUtil.notNull((Object)actual, (String)"actual must not be null");
        byte[] expectedChallengeBytes = expected.getValue();
        byte[] actualChallengeBytes = actual.getValue();
        if (!Arrays.equals(expectedChallengeBytes, actualChallengeBytes)) {
            this.logger.debug("Authentication failed: bad challenge is specified");
            throw new BadChallengeException("Actual Challenge does not match the expected Challenge");
        }
    }
}

