/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.util.Arrays;

public enum COSEAlgorithmIdentifier {
    RS1(-65535L, "SHA1withRSA", "SHA-1"),
    RS256(-257L, "SHA256withRSA", "SHA-256"),
    RS384(-258L, "SHA384withRSA", "SHA-384"),
    RS512(-259L, "SHA512withRSA", "SHA-512"),
    ES256(-7L, "SHA256withECDSA", "SHA-256"),
    ES384(-35L, "SHA384withECDSA", "SHA-384"),
    ES512(-36L, "SHA512withECDSA", "SHA-512");

    private final long value;
    private final String jcaName;
    private final String messageDigestJcaName;

    private COSEAlgorithmIdentifier(long value, String jcaName, String messageDigestJcaName) {
        this.value = value;
        this.jcaName = jcaName;
        this.messageDigestJcaName = messageDigestJcaName;
    }

    public static COSEAlgorithmIdentifier create(long value) {
        return Arrays.stream(COSEAlgorithmIdentifier.values()).filter(it -> it.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid COSE Algorithm identifier provided: " + value));
    }

    @JsonCreator
    private static COSEAlgorithmIdentifier fromJson(long value) throws InvalidFormatException {
        try {
            return COSEAlgorithmIdentifier.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "Invalid COSE Algorithm identifier provided", (Object)value, COSEAlgorithmIdentifier.class);
        }
    }

    @JsonValue
    public long getValue() {
        return this.value;
    }

    public String getJcaName() {
        return this.jcaName;
    }

    public String getMessageDigestJcaName() {
        return this.messageDigestJcaName;
    }
}

