/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.webauthn4j.converter.jackson.deserializer.COSEKeyEnvelope;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class AttestedCredentialDataConverter {
    private static final int AAGUID_LENGTH = 16;
    private static final int L_LENGTH = 2;
    private static final int AAGUID_INDEX = 0;
    private static final int L_INDEX = 16;
    private static final int CREDENTIAL_ID_INDEX = 18;
    private CborConverter cborConverter;

    public AttestedCredentialDataConverter(CborConverter cborConverter) {
        this.cborConverter = cborConverter;
    }

    public byte[] convert(AttestedCredentialData attestationData) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(attestationData.getAaguid().getBytes());
            byteArrayOutputStream.write(UnsignedNumberUtil.toBytes((int)attestationData.getCredentialId().length));
            byteArrayOutputStream.write(attestationData.getCredentialId());
            byteArrayOutputStream.write(this.convert(attestationData.getCOSEKey()));
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public AttestedCredentialData convert(ByteBuffer attestedCredentialData) {
        byte[] aaguidBytes = new byte[16];
        attestedCredentialData.get(aaguidBytes, 0, 16);
        AAGUID aaguid = new AAGUID(aaguidBytes);
        int length = UnsignedNumberUtil.getUnsignedShort((ByteBuffer)attestedCredentialData);
        byte[] credentialId = new byte[length];
        attestedCredentialData.get(credentialId, 0, length);
        byte[] remaining = new byte[attestedCredentialData.remaining()];
        attestedCredentialData.get(remaining);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(remaining);
        COSEKeyEnvelope coseKeyEnvelope = this.convertToCredentialPublicKey(byteArrayInputStream);
        COSEKey coseKey = coseKeyEnvelope.getCOSEKey();
        AttestedCredentialData result = new AttestedCredentialData(aaguid, credentialId, coseKey);
        int extensionsBufferLength = remaining.length - coseKeyEnvelope.getLength();
        attestedCredentialData.position(attestedCredentialData.position() - extensionsBufferLength);
        return result;
    }

    public AttestedCredentialData convert(byte[] attestedCredentialData) {
        return this.convert(ByteBuffer.wrap(attestedCredentialData));
    }

    public byte[] extractCredentialId(byte[] attestedCredentialData) {
        byte[] lengthBytes = Arrays.copyOfRange(attestedCredentialData, 16, 18);
        int credentialIdLength = UnsignedNumberUtil.getUnsignedShort((byte[])lengthBytes);
        return Arrays.copyOfRange(attestedCredentialData, 18, 18 + credentialIdLength);
    }

    COSEKeyEnvelope convertToCredentialPublicKey(InputStream inputStream) {
        return (COSEKeyEnvelope)this.cborConverter.readValue(inputStream, COSEKeyEnvelope.class);
    }

    byte[] convert(COSEKey coseKey) {
        return this.cborConverter.writeValueAsBytes(coseKey);
    }
}

