/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.response.attestation.AttestationObject;
import com.webauthn4j.util.Base64UrlUtil;
import com.webauthn4j.util.JacksonUtil;

public class AttestationObjectConverter {
    private CborConverter cborConverter;

    public AttestationObjectConverter(CborConverter cborConverter) {
        this.cborConverter = cborConverter;
    }

    public AttestationObject convert(String source) {
        if (source == null) {
            return null;
        }
        byte[] value = Base64UrlUtil.decode((String)source);
        return this.convert(value);
    }

    public AttestationObject convert(byte[] source) {
        if (source == null) {
            return null;
        }
        return (AttestationObject)this.cborConverter.readValue(source, AttestationObject.class);
    }

    public byte[] convertToBytes(AttestationObject source) {
        return this.cborConverter.writeValueAsBytes(source);
    }

    public String convertToString(AttestationObject source) {
        byte[] bytes = this.convertToBytes(source);
        return Base64UrlUtil.encodeToString((byte[])bytes);
    }

    public byte[] extractAuthenticatorData(byte[] attestationObject) {
        return JacksonUtil.binaryValue((JsonNode)this.cborConverter.readTree(attestationObject).get("authData"));
    }
}

