/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.authenticator;

import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.request.AuthenticatorTransport;
import com.webauthn4j.response.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.response.attestation.statement.AttestationStatement;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AuthenticatorImpl
implements Authenticator {
    private AttestedCredentialData attestedCredentialData;
    private AttestationStatement attestationStatement;
    private List<AuthenticatorTransport> authenticatorTransports;
    private long counter;

    public AuthenticatorImpl(AttestedCredentialData attestedCredentialData, AttestationStatement attestationStatement, long counter, List<AuthenticatorTransport> authenticatorTransports) {
        this.attestedCredentialData = attestedCredentialData;
        this.attestationStatement = attestationStatement;
        this.authenticatorTransports = Collections.unmodifiableList(authenticatorTransports);
        this.setCounter(counter);
    }

    public AuthenticatorImpl(AttestedCredentialData attestedCredentialData, AttestationStatement attestationStatement, long counter) {
        this(attestedCredentialData, attestationStatement, counter, Collections.emptyList());
    }

    @Override
    public AttestedCredentialData getAttestedCredentialData() {
        return this.attestedCredentialData;
    }

    public void setAttestedCredentialData(AttestedCredentialData attestedCredentialData) {
        this.attestedCredentialData = attestedCredentialData;
    }

    @Override
    public AttestationStatement getAttestationStatement() {
        return this.attestationStatement;
    }

    public void setAttestationStatement(AttestationStatement attestationStatement) {
        this.attestationStatement = attestationStatement;
    }

    @Override
    public long getCounter() {
        return this.counter;
    }

    @Override
    public void setCounter(long value) {
        if (value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("[Assertion failed] - this argument is unsigned int. it must not exceed 4294967295.");
        }
        if (value < 0L) {
            throw new IllegalArgumentException("[Assertion failed] - this argument is unsigned int. it must not be negative value.");
        }
        this.counter = value;
    }

    @Override
    public List<AuthenticatorTransport> getAuthenticatorTransports() {
        return this.authenticatorTransports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorImpl that = (AuthenticatorImpl)o;
        return this.counter == that.counter && Objects.equals(this.attestedCredentialData, that.attestedCredentialData) && Objects.equals(this.attestationStatement, that.attestationStatement) && Objects.equals(this.authenticatorTransports, that.authenticatorTransports);
    }

    public int hashCode() {
        return Objects.hash(this.attestedCredentialData, this.attestationStatement, this.authenticatorTransports, this.counter);
    }
}

