/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.response.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.webauthn4j.response.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.response.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.response.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.response.attestation.statement.TPMSAttest;
import com.webauthn4j.response.attestation.statement.TPMTPublic;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.util.Arrays;
import java.util.Objects;

@JsonIgnoreProperties(value={"format"})
@JsonTypeName(value="tpm")
public class TPMAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "tpm";
    public static final String VERSION_2_0 = "2.0";
    @JsonProperty
    private String ver;
    @JsonProperty
    private COSEAlgorithmIdentifier alg;
    @JsonProperty
    private AttestationCertificatePath x5c;
    @JsonProperty
    private byte[] ecdaaKeyId;
    @JsonProperty
    private byte[] sig;
    @JsonProperty
    private TPMSAttest certInfo;
    @JsonProperty
    private TPMTPublic pubArea;

    @JsonCreator
    public TPMAttestationStatement(@JsonProperty(value="ver") String ver, @JsonProperty(value="alg") COSEAlgorithmIdentifier alg, @JsonProperty(value="x5c") AttestationCertificatePath x5c, @JsonProperty(value="ecdaaKeyId") byte[] ecdaaKeyId, @JsonProperty(value="sig") byte[] sig, @JsonProperty(value="certInfo") TPMSAttest certInfo, @JsonProperty(value="pubArea") TPMTPublic pubArea) {
        this.ver = ver;
        this.alg = alg;
        this.x5c = x5c;
        this.ecdaaKeyId = ecdaaKeyId;
        this.sig = sig;
        this.certInfo = certInfo;
        this.pubArea = pubArea;
    }

    public TPMAttestationStatement(COSEAlgorithmIdentifier alg, AttestationCertificatePath x5c, byte[] sig, TPMSAttest certInfo, TPMTPublic pubArea) {
        this.ver = VERSION_2_0;
        this.alg = alg;
        this.x5c = x5c;
        this.sig = sig;
        this.certInfo = certInfo;
        this.pubArea = pubArea;
    }

    public String getVer() {
        return this.ver;
    }

    public COSEAlgorithmIdentifier getAlg() {
        return this.alg;
    }

    @Override
    public AttestationCertificatePath getX5c() {
        return this.x5c;
    }

    public byte[] getEcdaaKeyId() {
        return ArrayUtil.clone((byte[])this.ecdaaKeyId);
    }

    public byte[] getSig() {
        return ArrayUtil.clone((byte[])this.sig);
    }

    public TPMSAttest getCertInfo() {
        return this.certInfo;
    }

    public TPMTPublic getPubArea() {
        return this.pubArea;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public void validate() {
        if (this.x5c == null && this.ecdaaKeyId == null) {
            throw new ConstraintViolationException("x5c or ecdaaKeyId must be present");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMAttestationStatement that = (TPMAttestationStatement)o;
        return Objects.equals(this.ver, that.ver) && this.alg == that.alg && Objects.equals(this.x5c, that.x5c) && Arrays.equals(this.ecdaaKeyId, that.ecdaaKeyId) && Arrays.equals(this.sig, that.sig) && Objects.equals(this.certInfo, that.certInfo) && Objects.equals(this.pubArea, that.pubArea);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.ver, this.alg, this.x5c, this.certInfo, this.pubArea});
        result = 31 * result + Arrays.hashCode(this.ecdaaKeyId);
        result = 31 * result + Arrays.hashCode(this.sig);
        return result;
    }
}

