/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.response.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.response.extension.authenticator.ExtensionsAuthenticatorOutputs;
import com.webauthn4j.response.extension.client.ExtensionClientOutput;
import com.webauthn4j.response.extension.client.ExtensionsClientOutputs;
import com.webauthn4j.validator.exception.UnexpectedExtensionException;
import java.util.Collections;
import java.util.List;

class ExtensionValidator {
    ExtensionValidator() {
    }

    public void validate(ExtensionsClientOutputs<ExtensionClientOutput> extensionsClientOutputs, ExtensionsAuthenticatorOutputs<ExtensionAuthenticatorOutput> extensionsAuthenticatorOutputs, List<String> expectedExtensionIdentifiers) {
        List<Object> expected = expectedExtensionIdentifiers == null ? Collections.emptyList() : expectedExtensionIdentifiers;
        if (extensionsClientOutputs != null) {
            extensionsClientOutputs.keySet().forEach(identifier -> {
                if (!expected.contains(identifier)) {
                    throw new UnexpectedExtensionException(String.format("Unexpected client extension '%s' is contained", identifier));
                }
            });
        }
        if (extensionsAuthenticatorOutputs != null) {
            extensionsAuthenticatorOutputs.keySet().forEach(identifier -> {
                if (!expected.contains(identifier)) {
                    throw new UnexpectedExtensionException(String.format("Unexpected authenticator extension '%s' is contained", identifier));
                }
            });
        }
    }
}

