/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.util.WIP;

@WIP
public enum UserVerificationRequirement {
    REQUIRED("required"),
    PREFERRED("preferred"),
    DISCOURAGED("discouraged");

    private String value;

    private UserVerificationRequirement(String value) {
        this.value = value;
    }

    public static UserVerificationRequirement create(String value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "required": {
                return REQUIRED;
            }
            case "preferred": {
                return PREFERRED;
            }
            case "discouraged": {
                return DISCOURAGED;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static UserVerificationRequirement fromJson(String value) throws InvalidFormatException {
        try {
            return UserVerificationRequirement.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, UserVerificationRequirement.class);
        }
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }
}

