/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.anchor;

import com.webauthn4j.anchor.TrustAnchorProvider;
import com.webauthn4j.anchor.TrustAnchorResolver;
import com.webauthn4j.response.attestation.authenticator.AAGUID;
import com.webauthn4j.util.AssertUtil;
import java.security.cert.TrustAnchor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TrustAnchorResolverImpl
implements TrustAnchorResolver {
    private TrustAnchorProvider trustAnchorProvider;

    public TrustAnchorResolverImpl(TrustAnchorProvider trustAnchorProvider) {
        this.trustAnchorProvider = trustAnchorProvider;
    }

    @Override
    public Set<TrustAnchor> resolve(AAGUID aaguid) {
        AssertUtil.notNull((Object)aaguid, (String)"aaguid must not be null");
        Map<AAGUID, Set<TrustAnchor>> trustAnchors = this.trustAnchorProvider.provide();
        HashSet<TrustAnchor> set = new HashSet<TrustAnchor>();
        set.addAll(trustAnchors.getOrDefault(AAGUID.NULL, Collections.emptySet()));
        set.addAll(trustAnchors.getOrDefault(aaguid, Collections.emptySet()));
        return set;
    }
}

