/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.converter.jackson.WebAuthnModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

public class ObjectMapperUtil {
    private static ObjectMapper jsonMapper = ObjectMapperUtil.createWebAuthnClassesAwareJSONMapper();
    private static ObjectMapper cborMapper = ObjectMapperUtil.createWebAuthnClassesAwareCBORMapper();

    private ObjectMapperUtil() {
    }

    public static ObjectMapper createWebAuthnClassesAwareJSONMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new WebAuthnModule());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    public static ObjectMapper createWebAuthnClassesAwareCBORMapper() {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new CBORFactory());
        objectMapper.registerModule((Module)new WebAuthnModule());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    public static <T> T readJSONValue(String src, Class valueType) {
        try {
            return (T)jsonMapper.readValue(src, valueType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T readCBORValue(byte[] src, Class valueType) {
        try {
            return (T)cborMapper.readValue(src, valueType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T readCBORValue(InputStream src, Class valueType) {
        try {
            return (T)cborMapper.readValue(src, valueType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T readJSONValue(byte[] src, TypeReference valueTypeRef) {
        try {
            return (T)jsonMapper.readValue(src, valueTypeRef);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T readJSONValue(String src, TypeReference valueTypeRef) {
        try {
            return (T)jsonMapper.readValue(src, valueTypeRef);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T readCBORValue(byte[] src, TypeReference valueTypeRef) {
        try {
            return (T)cborMapper.readValue(src, valueTypeRef);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] writeValueAsJSONBytes(Object value) {
        try {
            return jsonMapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static byte[] writeValueAsCBORBytes(Object value) {
        try {
            return cborMapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static String writeValueAsJSONString(Object value) {
        try {
            return jsonMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }
}

