/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.webauthn4j.client.CollectedClientData;
import com.webauthn4j.converter.jackson.ObjectMapperUtil;
import com.webauthn4j.util.Base64UrlUtil;
import java.nio.charset.StandardCharsets;

public class CollectedClientDataConverter {
    public CollectedClientData convert(String base64UrlString) {
        byte[] bytes = Base64UrlUtil.decode((String)base64UrlString);
        return this.convert(bytes);
    }

    public CollectedClientData convert(byte[] source) {
        String jsonString = new String(source, StandardCharsets.UTF_8);
        return (CollectedClientData)ObjectMapperUtil.readJSONValue(jsonString, CollectedClientData.class);
    }

    public byte[] convertToBytes(CollectedClientData source) {
        return ObjectMapperUtil.writeValueAsJSONBytes(source);
    }

    public String convertToBase64UrlString(CollectedClientData source) {
        byte[] bytes = this.convertToBytes(source);
        return Base64UrlUtil.encodeToString((byte[])bytes);
    }
}

