/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.webauthn4j.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.attestation.authenticator.CredentialPublicKey;
import com.webauthn4j.attestation.authenticator.extension.Extension;
import com.webauthn4j.converter.jackson.ObjectMapperUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class AuthenticatorDataConverter {
    private ObjectMapper cborMapper;

    public byte[] convert(AuthenticatorData source) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] rpIdHash = source.getRpIdHash();
            byteArrayOutputStream.write(rpIdHash);
            byteArrayOutputStream.write(new byte[]{source.getFlags()});
            byteArrayOutputStream.write(UnsignedNumberUtil.toBytes((long)source.getSignCount()));
            if (source.getAttestedCredentialData() != null) {
                byteArrayOutputStream.write(this.convert(source.getAttestedCredentialData()));
            }
            byteArrayOutputStream.write(this.convert(source.getExtensions()));
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private byte[] convert(AttestedCredentialData attestationData) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(attestationData.getAaGuid());
        byteArrayOutputStream.write(UnsignedNumberUtil.toBytes((int)attestationData.getCredentialId().length));
        byteArrayOutputStream.write(attestationData.getCredentialId());
        byteArrayOutputStream.write(this.convert(attestationData.getCredentialPublicKey()));
        return byteArrayOutputStream.toByteArray();
    }

    public AuthenticatorData convert(byte[] value) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(value);
        byte[] rpIdHash = new byte[32];
        byteBuffer.get(rpIdHash, 0, 32);
        byte flags = byteBuffer.get();
        long counter = UnsignedNumberUtil.getUnsignedInt((ByteBuffer)byteBuffer);
        AttestedCredentialData attestationData = AuthenticatorData.checkFlagAT(flags) ? this.convertToAttestedCredentialData(byteBuffer) : null;
        List<Extension> extensions = AuthenticatorData.checkFlagED(flags) ? this.convertToExtensions(byteBuffer) : null;
        return new AuthenticatorData(rpIdHash, flags, counter, attestationData, extensions);
    }

    private AttestedCredentialData convertToAttestedCredentialData(ByteBuffer byteBuffer) {
        byte[] aaGuid = new byte[16];
        byteBuffer.get(aaGuid, 0, 16);
        int length = UnsignedNumberUtil.getUnsignedShort((ByteBuffer)byteBuffer);
        byte[] credentialId = new byte[length];
        byteBuffer.get(credentialId, 0, length);
        byte[] remaining = new byte[byteBuffer.remaining()];
        byteBuffer.get(remaining);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(remaining);
        CredentialPublicKey credentialPublicKey = this.convertToCredentialPublicKey(byteArrayInputStream);
        AttestedCredentialData attestationData = new AttestedCredentialData(aaGuid, credentialId, credentialPublicKey);
        int extensionsBufferLength = byteArrayInputStream.available();
        byteBuffer.position(byteBuffer.position() - extensionsBufferLength);
        return attestationData;
    }

    private CredentialPublicKey convertToCredentialPublicKey(InputStream inputStream) {
        try {
            return (CredentialPublicKey)this.getCborMapper().readValue(inputStream, CredentialPublicKey.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    List<Extension> convertToExtensions(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() == 0) {
            return new ArrayList<Extension>();
        }
        byte[] remaining = new byte[byteBuffer.remaining()];
        byteBuffer.get(remaining);
        try {
            return (List)this.getCborMapper().readValue(remaining, (TypeReference)new TypeReference<List<Extension>>(){});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    byte[] convert(List<Extension> extensions) {
        return new byte[0];
    }

    byte[] convert(CredentialPublicKey credentialPublicKey) throws JsonProcessingException {
        return this.getCborMapper().writeValueAsBytes((Object)credentialPublicKey);
    }

    private ObjectMapper getCborMapper() {
        if (this.cborMapper == null) {
            this.cborMapper = ObjectMapperUtil.createCBORMapper();
        }
        return this.cborMapper;
    }
}

