/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.attestation.authenticator;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.attestation.authenticator.AbstractCredentialPublicKey;
import com.webauthn4j.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.attestation.statement.COSEKeyType;
import com.webauthn4j.util.exception.NotImplementedException;
import com.webauthn4j.util.exception.UnexpectedCheckedException;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;

public class RSACredentialPublicKey
extends AbstractCredentialPublicKey {
    @JsonProperty(value="-1")
    private byte[] n;
    @JsonProperty(value="-2")
    private byte[] e;

    public RSACredentialPublicKey(COSEKeyType keyType, byte[] keyId, COSEAlgorithmIdentifier algorithm, int[] keyOpts, byte[] baseIV, byte[] n, byte[] e) {
        super(keyType, keyId, algorithm, keyOpts, baseIV);
        this.n = n;
        this.e = e;
    }

    public RSACredentialPublicKey() {
    }

    public byte[] getN() {
        return this.n;
    }

    public byte[] getE() {
        return this.e;
    }

    @Override
    public PublicKey getPublicKey() {
        RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(1, this.getN()), new BigInteger(1, this.getE()));
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new UnexpectedCheckedException((Throwable)ex);
        }
    }

    @Override
    public byte[] getBytes() {
        throw new NotImplementedException();
    }

    @Override
    public void validate() {
        if (this.getAlgorithm() == null) {
            throw new ConstraintViolationException("algorithm must not be null");
        }
        if (this.e == null) {
            throw new ConstraintViolationException("e must not be null");
        }
        if (this.n == null) {
            throw new ConstraintViolationException("n must not be null");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RSACredentialPublicKey that = (RSACredentialPublicKey)o;
        return Arrays.equals(this.n, that.n) && Arrays.equals(this.e, that.e);
    }

    @Override
    public int hashCode() {
        int result = Arrays.hashCode(this.n);
        result = 31 * result + Arrays.hashCode(this.e);
        return result;
    }
}

