/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.attestation.authenticator;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.attestation.authenticator.AbstractCredentialPublicKey;
import com.webauthn4j.attestation.authenticator.CredentialPublicKey;
import com.webauthn4j.attestation.authenticator.Curve;
import com.webauthn4j.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.attestation.statement.COSEKeyType;
import com.webauthn4j.util.exception.UnexpectedCheckedException;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Objects;

public class ECCredentialPublicKey
extends AbstractCredentialPublicKey
implements Serializable {
    @JsonProperty(value="-1")
    private Curve curve;
    @JsonProperty(value="-2")
    private byte[] x;
    @JsonProperty(value="-3")
    private byte[] y;
    @JsonProperty(value="-4")
    private byte[] d;

    public ECCredentialPublicKey() {
    }

    public ECCredentialPublicKey(COSEKeyType keyType, byte[] keyId, COSEAlgorithmIdentifier algorithm, int[] keyOpts, byte[] baseIV, Curve curve, byte[] x, byte[] y, byte[] d) {
        super(keyType, keyId, algorithm, keyOpts, baseIV);
        this.curve = curve;
        this.x = x;
        this.y = y;
        this.d = d;
    }

    public ECCredentialPublicKey(COSEKeyType keyType, byte[] keyId, COSEAlgorithmIdentifier algorithm, int[] keyOpts, byte[] baseIV, Curve curve, byte[] x, byte[] y) {
        super(keyType, keyId, algorithm, keyOpts, baseIV);
        this.curve = curve;
        this.x = x;
        this.y = y;
    }

    public ECCredentialPublicKey(COSEKeyType keyType, byte[] keyId, COSEAlgorithmIdentifier algorithm, int[] keyOpts, byte[] baseIV, Curve curve, byte[] d) {
        super(keyType, keyId, algorithm, keyOpts, baseIV);
        this.curve = curve;
        this.d = d;
    }

    public static ECCredentialPublicKey createFromUncompressedECCKey(byte[] publicKey) {
        if (publicKey.length != 65) {
            throw new IllegalArgumentException("publicKey must be 65 bytes length");
        }
        byte[] x = Arrays.copyOfRange(publicKey, 1, 33);
        byte[] y = Arrays.copyOfRange(publicKey, 33, 65);
        return new ECCredentialPublicKey(COSEKeyType.EC2, null, COSEAlgorithmIdentifier.ES256, null, null, Curve.SECP256R1, x, y);
    }

    public static CredentialPublicKey create(ECPublicKey publicKey) {
        ECPoint ecPoint = publicKey.getW();
        byte[] x = ecPoint.getAffineX().toByteArray();
        byte[] y = ecPoint.getAffineY().toByteArray();
        return new ECCredentialPublicKey(COSEKeyType.EC2, null, COSEAlgorithmIdentifier.ES256, null, null, Curve.SECP256R1, x, y);
    }

    public Curve getCurve() {
        return this.curve;
    }

    public byte[] getX() {
        return this.x;
    }

    public byte[] getY() {
        return this.y;
    }

    public byte[] getD() {
        return this.d;
    }

    @Override
    public byte[] getBytes() {
        byte format = 4;
        return ByteBuffer.allocate(1 + this.x.length + this.y.length).put(format).put(this.x).put(this.y).array();
    }

    @Override
    public PublicKey getPublicKey() {
        ECPoint ecPoint = new ECPoint(new BigInteger(1, this.getX()), new BigInteger(1, this.getY()));
        try {
            ECParameterSpec ecParameterSpec = this.curve.getECParameterSpec();
            ECPublicKeySpec spec = new ECPublicKeySpec(ecPoint, ecParameterSpec);
            KeyFactory factory = KeyFactory.getInstance("EC");
            return factory.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnexpectedCheckedException((Throwable)e);
        }
    }

    @Override
    public void validate() {
        if (this.getAlgorithm() == null) {
            throw new ConstraintViolationException("algorithm must not be null");
        }
        if (this.curve == null) {
            throw new ConstraintViolationException("curve must not be null");
        }
        if (this.d == null) {
            if (this.x == null) {
                throw new ConstraintViolationException("x must not be null");
            }
            if (this.y == null) {
                throw new ConstraintViolationException("y must not be null");
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECCredentialPublicKey that = (ECCredentialPublicKey)o;
        return this.curve == that.curve && Arrays.equals(this.x, that.x) && Arrays.equals(this.y, that.y) && Arrays.equals(this.d, that.d);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(new Object[]{this.curve});
        result = 31 * result + Arrays.hashCode(this.x);
        result = 31 * result + Arrays.hashCode(this.y);
        result = 31 * result + Arrays.hashCode(this.d);
        return result;
    }
}

