/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j;

import com.webauthn4j.server.ServerProperty;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public class WebAuthnAuthenticationContext {
    private final byte[] credentialId;
    private final byte[] collectedClientData;
    private final byte[] authenticatorData;
    private final byte[] signature;
    private final ServerProperty serverProperty;

    public WebAuthnAuthenticationContext(byte[] credentialId, byte[] collectedClientData, byte[] authenticatorData, byte[] signature, ServerProperty serverProperty) {
        this.credentialId = credentialId;
        this.collectedClientData = collectedClientData;
        this.authenticatorData = authenticatorData;
        this.signature = signature;
        this.serverProperty = serverProperty;
    }

    public byte[] getCredentialId() {
        return this.credentialId;
    }

    public byte[] getCollectedClientData() {
        return this.collectedClientData;
    }

    public String getCollectedClientDataJson() {
        return new String(this.collectedClientData, StandardCharsets.UTF_8);
    }

    public byte[] getAuthenticatorData() {
        return this.authenticatorData;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public ServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebAuthnAuthenticationContext that = (WebAuthnAuthenticationContext)o;
        return Arrays.equals(this.credentialId, that.credentialId) && Arrays.equals(this.collectedClientData, that.collectedClientData) && Arrays.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.signature, that.signature) && Objects.equals(this.serverProperty, that.serverProperty);
    }

    public int hashCode() {
        int result = Objects.hash(this.serverProperty);
        result = 31 * result + Arrays.hashCode(this.credentialId);
        result = 31 * result + Arrays.hashCode(this.collectedClientData);
        result = 31 * result + Arrays.hashCode(this.authenticatorData);
        result = 31 * result + Arrays.hashCode(this.signature);
        return result;
    }
}

