/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.internal;

import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.credential.CoreCredentialRecord;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.verifier.exception.BadBackupEligibleFlagException;

public class BEFlagVerifier {
    private BEFlagVerifier() {
    }

    public static void verify(Authenticator authenticator, AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        CoreCredentialRecord coreCredentialRecord;
        Boolean backEligibleRecordValue;
        if (authenticator instanceof CoreCredentialRecord && (backEligibleRecordValue = (coreCredentialRecord = (CoreCredentialRecord)((Object)authenticator)).isBackupEligible()) != null) {
            if (backEligibleRecordValue.booleanValue()) {
                if (!authenticatorData.isFlagBE()) {
                    throw new BadBackupEligibleFlagException("Although credential record BE flag is set, current BE flag is not set");
                }
            } else if (authenticatorData.isFlagBE()) {
                throw new BadBackupEligibleFlagException("Although credential record BE flag is not set, current BE flag is set");
            }
        }
    }
}

