/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier;

import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.credential.CoreCredentialRecord;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.AuthenticationObject;
import com.webauthn4j.verifier.AuthenticatorExtensionVerifier;
import com.webauthn4j.verifier.ClientExtensionVerifier;
import com.webauthn4j.verifier.CoreMaliciousCounterValueHandler;
import com.webauthn4j.verifier.CustomAuthenticationVerifier;
import com.webauthn4j.verifier.DefaultCoreMaliciousCounterValueHandler;
import com.webauthn4j.verifier.OriginVerifier;
import com.webauthn4j.verifier.OriginVerifierImpl;
import com.webauthn4j.verifier.exception.ConstraintViolationException;
import com.webauthn4j.verifier.exception.InconsistentClientDataTypeException;
import com.webauthn4j.verifier.internal.AssertionSignatureVerifier;
import com.webauthn4j.verifier.internal.BEBSFlagsVerifier;
import com.webauthn4j.verifier.internal.BEFlagVerifier;
import com.webauthn4j.verifier.internal.BeanAssertUtil;
import com.webauthn4j.verifier.internal.ChallengeVerifier;
import com.webauthn4j.verifier.internal.CredentialIdVerifier;
import com.webauthn4j.verifier.internal.RpIdHashVerifier;
import com.webauthn4j.verifier.internal.TokenBindingVerifier;
import com.webauthn4j.verifier.internal.TopOriginVerifier;
import com.webauthn4j.verifier.internal.UPUVFlagsVerifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AuthenticationDataVerifier {
    private final AssertionSignatureVerifier assertionSignatureVerifier = new AssertionSignatureVerifier();
    private final ClientExtensionVerifier clientExtensionVerifier = new ClientExtensionVerifier();
    private final AuthenticatorExtensionVerifier authenticatorExtensionVerifier = new AuthenticatorExtensionVerifier();
    private final List<CustomAuthenticationVerifier> customAuthenticationVerifiers;
    private OriginVerifier originVerifier = new OriginVerifierImpl();
    private TopOriginVerifier topOriginVerifier = new TopOriginVerifier();
    private CoreMaliciousCounterValueHandler maliciousCounterValueHandler = new DefaultCoreMaliciousCounterValueHandler();

    public AuthenticationDataVerifier(@NotNull List<CustomAuthenticationVerifier> customAuthenticationVerifiers) {
        AssertUtil.notNull(customAuthenticationVerifiers, "customAuthenticationVerifiers must not be null");
        this.customAuthenticationVerifiers = customAuthenticationVerifiers;
    }

    public AuthenticationDataVerifier() {
        this.customAuthenticationVerifiers = new ArrayList<CustomAuthenticationVerifier>();
    }

    public void verify(@NotNull AuthenticationData authenticationData, @NotNull AuthenticationParameters authenticationParameters) {
        BeanAssertUtil.validate(authenticationData);
        AssertUtil.notNull(authenticationParameters, "authenticationParameters must not be null");
        AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions = authenticationData.getClientExtensions();
        byte[] credentialId = authenticationData.getCredentialId();
        List<byte[]> allowCredentials = authenticationParameters.getAllowCredentials();
        CredentialIdVerifier.verify(credentialId, allowCredentials);
        byte[] cData = authenticationData.getCollectedClientDataBytes();
        byte[] aData = authenticationData.getAuthenticatorDataBytes();
        CollectedClientData collectedClientData = authenticationData.getCollectedClientData();
        AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData = authenticationData.getAuthenticatorData();
        ServerProperty serverProperty = authenticationParameters.getServerProperty();
        BeanAssertUtil.validate(collectedClientData);
        BeanAssertUtil.validate(authenticatorData);
        if (authenticatorData.getAttestedCredentialData() != null) {
            throw new ConstraintViolationException("attestedCredentialData must be null on authentication");
        }
        Authenticator authenticator = authenticationParameters.getAuthenticator();
        AuthenticationObject authenticationObject = new AuthenticationObject(credentialId, authenticatorData, aData, collectedClientData, cData, clientExtensions, serverProperty, authenticator);
        if (!Objects.equals(collectedClientData.getType(), ClientDataType.WEBAUTHN_GET)) {
            throw new InconsistentClientDataTypeException("ClientData.type must be 'get' on authentication, but it isn't.");
        }
        ChallengeVerifier.verify(collectedClientData, serverProperty);
        this.originVerifier.verify(authenticationObject);
        this.topOriginVerifier.verify(authenticationObject);
        TokenBindingVerifier.verify(collectedClientData.getTokenBinding(), serverProperty.getTokenBindingId());
        RpIdHashVerifier.verify(authenticatorData.getRpIdHash(), serverProperty);
        UPUVFlagsVerifier.verify(authenticatorData, authenticationParameters.isUserPresenceRequired(), authenticationParameters.isUserVerificationRequired());
        BEBSFlagsVerifier.verify(authenticatorData);
        BEFlagVerifier.verify(authenticator, authenticatorData);
        AuthenticationExtensionsAuthenticatorOutputs<AuthenticationExtensionAuthenticatorOutput> authenticationExtensionsAuthenticatorOutputs = authenticatorData.getExtensions();
        this.clientExtensionVerifier.verify(clientExtensions);
        this.authenticatorExtensionVerifier.verify(authenticationExtensionsAuthenticatorOutputs);
        this.assertionSignatureVerifier.verify(authenticationData, authenticator.getAttestedCredentialData().getCOSEKey());
        long presentedSignCount = authenticatorData.getSignCount();
        long storedSignCount = authenticator.getCounter();
        if ((presentedSignCount > 0L || storedSignCount > 0L) && presentedSignCount <= storedSignCount) {
            this.maliciousCounterValueHandler.maliciousCounterValueDetected(authenticationObject);
        }
        AuthenticationDataVerifier.updateRecord(authenticator, authenticatorData);
        for (CustomAuthenticationVerifier customAuthenticationVerifier : this.customAuthenticationVerifiers) {
            customAuthenticationVerifier.verify(authenticationObject);
        }
    }

    static void updateRecord(Authenticator authenticator, AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        authenticator.setCounter(authenticatorData.getSignCount());
        if (authenticator instanceof CoreCredentialRecord) {
            CoreCredentialRecord coreCredentialRecord = (CoreCredentialRecord)((Object)authenticator);
            coreCredentialRecord.setBackedUp(authenticatorData.isFlagBS());
            Boolean uvInitializedRecord = coreCredentialRecord.isUvInitialized();
            if (Objects.isNull(uvInitializedRecord) || Boolean.FALSE.equals(uvInitializedRecord)) {
                coreCredentialRecord.setUvInitialized(authenticatorData.isFlagUV());
            }
        }
    }

    @NotNull
    public CoreMaliciousCounterValueHandler getMaliciousCounterValueHandler() {
        return this.maliciousCounterValueHandler;
    }

    public void setMaliciousCounterValueHandler(@NotNull CoreMaliciousCounterValueHandler maliciousCounterValueHandler) {
        AssertUtil.notNull(maliciousCounterValueHandler, "maliciousCounterValueHandler must not be null");
        this.maliciousCounterValueHandler = maliciousCounterValueHandler;
    }

    public OriginVerifier getOriginVerifier() {
        return this.originVerifier;
    }

    public void setOriginVerifier(OriginVerifier originVerifier) {
        this.originVerifier = originVerifier;
    }

    @NotNull
    public List<CustomAuthenticationVerifier> getCustomAuthenticationVerifiers() {
        return this.customAuthenticationVerifiers;
    }

    @Deprecated
    public boolean isCrossOriginAllowed() {
        return !this.topOriginVerifier.isForceBlockCrossOrigin();
    }

    @Deprecated
    public void setCrossOriginAllowed(boolean crossOriginAllowed) {
        this.topOriginVerifier.setForceBlockCrossOrigin(!crossOriginAllowed);
    }
}

