/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator.attestation.statement.u2f;

import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.EC2COSEKey;
import com.webauthn4j.data.attestation.statement.AttestationType;
import com.webauthn4j.data.attestation.statement.FIDOU2FAttestationStatement;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.ECUtil;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.validator.CoreRegistrationObject;
import com.webauthn4j.validator.attestation.statement.AbstractStatementValidator;
import com.webauthn4j.validator.exception.BadAttestationStatementException;
import com.webauthn4j.validator.exception.BadSignatureException;
import com.webauthn4j.validator.exception.CertificateException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FIDOU2FAttestationStatementValidator
extends AbstractStatementValidator<FIDOU2FAttestationStatement> {
    @Override
    public @NonNull AttestationType validate(@NonNull CoreRegistrationObject registrationObject) {
        AssertUtil.notNull((Object)registrationObject, (String)"registrationObject must not be null");
        if (!this.supports(registrationObject)) {
            throw new IllegalArgumentException("Specified format is not supported by " + this.getClass().getName());
        }
        FIDOU2FAttestationStatement attestationStatement = (FIDOU2FAttestationStatement)registrationObject.getAttestationObject().getAttestationStatement();
        this.validateAttestationStatementNotNull(attestationStatement);
        this.validateAttestationStatement(attestationStatement);
        this.validateSignature(registrationObject);
        return AttestationType.BASIC;
    }

    void validateAttestationStatementNotNull(FIDOU2FAttestationStatement attestationStatement) {
        if (attestationStatement == null) {
            throw new BadAttestationStatementException("attestation statement is not found.");
        }
        if (attestationStatement.getSig() == null) {
            throw new BadAttestationStatementException("sig must not be null");
        }
        if (attestationStatement.getX5c() == null) {
            throw new BadAttestationStatementException("x5c must not be null");
        }
    }

    void validateAttestationStatement(@NonNull FIDOU2FAttestationStatement attestationStatement) {
        if (attestationStatement.getX5c().size() != 1) {
            throw new BadAttestationStatementException("FIDO-U2F attestation statement must have only one certificate.");
        }
        PublicKey publicKey = attestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate().getPublicKey();
        this.validatePublicKey(publicKey);
    }

    void validatePublicKey(@NonNull PublicKey publicKey) {
        if (!publicKey.getAlgorithm().equals("EC")) {
            throw new CertificateException("FIDO-U2F attestation statement supports ECDSA only.");
        }
        if (!((ECPublicKey)publicKey).getParams().equals(ECUtil.P_256_SPEC)) {
            throw new CertificateException("FIDO-U2F attestation statement supports secp256r1 curve only.");
        }
    }

    private void validateSignature(@NonNull CoreRegistrationObject registrationObject) {
        FIDOU2FAttestationStatement attestationStatement = (FIDOU2FAttestationStatement)registrationObject.getAttestationObject().getAttestationStatement();
        byte[] signedData = this.getSignedData(registrationObject);
        byte[] signature = attestationStatement.getSig();
        PublicKey publicKey = this.getPublicKey(attestationStatement);
        try {
            Signature verifier = Signature.getInstance("SHA256withECDSA");
            verifier.initVerify(publicKey);
            verifier.update(signedData);
            if (verifier.verify(signature)) {
                return;
            }
            throw new BadSignatureException("`sig` in attestation statement is not valid signature. Please refer U2F Raw Message Formats. https://fidoalliance.org/specs/fido-u2f-v1.1-id-20160915/fido-u2f-raw-message-formats-v1.1-id-20160915.html");
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new BadSignatureException("`sig` in attestation statement is not valid signature. Please refer U2F Raw Message Formats. https://fidoalliance.org/specs/fido-u2f-v1.1-id-20160915/fido-u2f-raw-message-formats-v1.1-id-20160915.html");
        }
    }

    private byte[] getSignedData(@NonNull CoreRegistrationObject registrationObject) {
        String rpId = registrationObject.getServerProperty().getRpId();
        MessageDigest messageDigest = MessageDigestUtil.createSHA256();
        AttestationObject attestationObject = registrationObject.getAttestationObject();
        EC2COSEKey credentialPublicKey = (EC2COSEKey)attestationObject.getAuthenticatorData().getAttestedCredentialData().getCOSEKey();
        byte[] rpIdBytes = rpId.getBytes(StandardCharsets.UTF_8);
        byte[] applicationParameter = messageDigest.digest(rpIdBytes);
        byte[] challengeParameter = registrationObject.getClientDataHash();
        byte[] keyHandle = attestationObject.getAuthenticatorData().getAttestedCredentialData().getCredentialId();
        byte[] userPublicKeyBytes = this.getPublicKeyBytes(credentialPublicKey);
        ByteBuffer byteBuffer = ByteBuffer.allocate(65 + keyHandle.length + 65);
        byteBuffer.put((byte)0);
        byteBuffer.put(applicationParameter);
        byteBuffer.put(challengeParameter);
        byteBuffer.put(keyHandle);
        byteBuffer.put(userPublicKeyBytes);
        return byteBuffer.array();
    }

    private byte[] getPublicKeyBytes(@NonNull EC2COSEKey ec2CoseKey) {
        byte[] x = ec2CoseKey.getX();
        byte[] y = ec2CoseKey.getY();
        byte format = 4;
        return ByteBuffer.allocate(1 + x.length + y.length).put(format).put(x).put(y).array();
    }

    private PublicKey getPublicKey(@NonNull FIDOU2FAttestationStatement attestationStatement) {
        X509Certificate cert = attestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate();
        return cert.getPublicKey();
    }
}

