/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier;

import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.verifier.CoreAuthenticationObject;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthenticationObject
extends CoreAuthenticationObject {
    private final CollectedClientData collectedClientData;
    private final byte[] collectedClientDataBytes;
    private final AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions;

    public AuthenticationObject(@NotNull byte[] credentialId, @NotNull AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData, @NotNull byte[] authenticatorDataBytes, @NotNull CollectedClientData collectedClientData, @NotNull byte[] collectedClientDataBytes, @Nullable AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions, @NotNull ServerProperty serverProperty, @NotNull Authenticator authenticator) {
        super(credentialId, authenticatorData, authenticatorDataBytes, MessageDigestUtil.createSHA256().digest(collectedClientDataBytes), serverProperty, authenticator);
        AssertUtil.notNull((Object)collectedClientData, (String)"collectedClientData must not be null");
        AssertUtil.notNull((Object)collectedClientDataBytes, (String)"collectedClientDataBytes must not be null");
        this.collectedClientData = collectedClientData;
        this.collectedClientDataBytes = ArrayUtil.clone((byte[])collectedClientDataBytes);
        this.clientExtensions = clientExtensions;
    }

    @NotNull
    public CollectedClientData getCollectedClientData() {
        return this.collectedClientData;
    }

    @NotNull
    public byte[] getCollectedClientDataBytes() {
        return ArrayUtil.clone((byte[])this.collectedClientDataBytes);
    }

    @Nullable
    public AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> getClientExtensions() {
        return this.clientExtensions;
    }

    @Override
    @NotNull
    public ServerProperty getServerProperty() {
        return (ServerProperty)super.getServerProperty();
    }

    @Override
    @NotNull
    public Authenticator getAuthenticator() {
        return (Authenticator)super.getAuthenticator();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthenticationObject that = (AuthenticationObject)o;
        return Objects.equals(this.collectedClientData, that.collectedClientData) && Arrays.equals(this.collectedClientDataBytes, that.collectedClientDataBytes) && Objects.equals(this.clientExtensions, that.clientExtensions);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.collectedClientData, this.clientExtensions);
        result = 31 * result + Arrays.hashCode(this.collectedClientDataBytes);
        return result;
    }
}

