/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator.attestation.statement.androidsafetynet;

import com.webauthn4j.data.attestation.statement.AndroidSafetyNetAttestationStatement;
import com.webauthn4j.data.attestation.statement.AttestationCertificate;
import com.webauthn4j.data.attestation.statement.AttestationType;
import com.webauthn4j.data.attestation.statement.Response;
import com.webauthn4j.data.jws.JWS;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.Base64Util;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.validator.CoreRegistrationObject;
import com.webauthn4j.validator.attestation.statement.AbstractStatementValidator;
import com.webauthn4j.validator.attestation.statement.androidsafetynet.GooglePlayServiceVersionValidator;
import com.webauthn4j.validator.exception.BadAttestationStatementException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSafetyNetAttestationStatementValidator
extends AbstractStatementValidator<AndroidSafetyNetAttestationStatement> {
    private GooglePlayServiceVersionValidator versionValidator = new DefaultVersionValidator();
    private int forwardThreshold = 0;
    private int backwardThreshold = 60;

    @Override
    @NotNull
    public AttestationType validate(@NotNull CoreRegistrationObject registrationObject) {
        AssertUtil.notNull((Object)registrationObject, (String)"registrationObject must not be null");
        if (!this.supports(registrationObject)) {
            throw new IllegalArgumentException("Specified format is not supported by " + this.getClass().getName());
        }
        AndroidSafetyNetAttestationStatement attestationStatement = (AndroidSafetyNetAttestationStatement)registrationObject.getAttestationObject().getAttestationStatement();
        this.validateAttestationStatementNotNull(attestationStatement);
        if (attestationStatement.getX5c().isEmpty()) {
            throw new BadAttestationStatementException("No attestation certificate is found in android safetynet attestation statement.");
        }
        this.versionValidator.validate(attestationStatement.getVer());
        Response response = attestationStatement.getResponse().getPayload();
        String nonce = response.getNonce();
        byte[] authenticatorData = registrationObject.getAuthenticatorDataBytes();
        this.validateNonce(nonce, authenticatorData, registrationObject.getClientDataHash());
        AttestationCertificate attestationCertificate = attestationStatement.getX5c().getEndEntityAttestationCertificate();
        if (!Objects.equals(attestationCertificate.getSubjectCommonName(), "attest.android.com")) {
            throw new BadAttestationStatementException("The attestation certificate is not issued to 'attest.android.com'.");
        }
        if (!Objects.equals(response.getCtsProfileMatch(), true)) {
            throw new BadAttestationStatementException("The profile of the device doesn't match the profile of a device that has passed Android Compatibility Test Suite.");
        }
        if (response.getTimestampMs() == null) {
            throw new BadAttestationStatementException("timestampMs is null.");
        }
        if (Instant.ofEpochMilli(response.getTimestampMs()).isBefore(registrationObject.getTimestamp().minus(Duration.ofSeconds(this.backwardThreshold)))) {
            throw new BadAttestationStatementException("timestampMs violates backwardThreshold.");
        }
        if (Instant.ofEpochMilli(response.getTimestampMs()).isAfter(registrationObject.getTimestamp().plus(Duration.ofSeconds(this.forwardThreshold)))) {
            throw new BadAttestationStatementException("timestampMs violates forwardThreshold.");
        }
        if (!attestationStatement.getResponse().isValidSignature()) {
            throw new BadAttestationStatementException("Android safetynet response in the attestation statement doesn't have a valid signature.");
        }
        return AttestationType.BASIC;
    }

    void validateAttestationStatementNotNull(AndroidSafetyNetAttestationStatement attestationStatement) {
        if (attestationStatement == null) {
            throw new BadAttestationStatementException("attestation statement is not found.");
        }
        this.validateJWSNotNull(attestationStatement.getResponse());
        if (attestationStatement.getX5c() == null) {
            throw new BadAttestationStatementException("x5c must not be null");
        }
    }

    void validateJWSNotNull(JWS<Response> response) {
        if (response == null) {
            throw new BadAttestationStatementException("response must not be null.");
        }
        this.validateResponseNotNull(response.getPayload());
    }

    void validateResponseNotNull(Response response) {
        if (response == null) {
            throw new BadAttestationStatementException("response must not be null.");
        }
        if (response.getNonce() == null) {
            throw new BadAttestationStatementException("nonce must not be null.");
        }
        if (response.getTimestampMs() == null) {
            throw new BadAttestationStatementException("timeStampMs must not be null.");
        }
        if (response.getApkPackageName() == null) {
            throw new BadAttestationStatementException("apkPackageName must not be null.");
        }
        if (response.getApkCertificateDigestSha256() == null) {
            throw new BadAttestationStatementException("apkCertificateDigestSha256 must not be null.");
        }
        if (response.getApkDigestSha256() == null) {
            throw new BadAttestationStatementException("apkDigestSha256 must not be null.");
        }
        if (response.getCtsProfileMatch() == null) {
            throw new BadAttestationStatementException("ctsProfileMatch must not be null.");
        }
        if (response.getBasicIntegrity() == null) {
            throw new BadAttestationStatementException("basicIntegrity must not be null.");
        }
    }

    private void validateNonce(@Nullable String nonce, @NotNull byte[] authenticatorData, @NotNull byte[] clientDataHash) {
        if (nonce == null) {
            throw new BadAttestationStatementException("Nonce in the Android safetynet response is null.");
        }
        ByteBuffer buffer = ByteBuffer.allocate(authenticatorData.length + clientDataHash.length);
        byte[] data = buffer.put(authenticatorData).put(clientDataHash).array();
        byte[] hash = MessageDigestUtil.createSHA256().digest(data);
        if (!Arrays.equals(hash, Base64Util.decode((String)nonce))) {
            throw new BadAttestationStatementException("Nonce in the Android safetynet response doesn't match.");
        }
    }

    public int getForwardThreshold() {
        return this.forwardThreshold;
    }

    public void setForwardThreshold(int forwardThreshold) {
        this.forwardThreshold = forwardThreshold;
    }

    public int getBackwardThreshold() {
        return this.backwardThreshold;
    }

    public void setBackwardThreshold(int backwardThreshold) {
        this.backwardThreshold = backwardThreshold;
    }

    @NotNull
    public GooglePlayServiceVersionValidator getVersionValidator() {
        return this.versionValidator;
    }

    public void setVersionValidator(@NotNull GooglePlayServiceVersionValidator versionValidator) {
        AssertUtil.notNull((Object)versionValidator, (String)"versionValidator must not be null");
        this.versionValidator = versionValidator;
    }

    private static class DefaultVersionValidator
    implements GooglePlayServiceVersionValidator {
        private static final int MINIMAL_VERSION = 0;

        private DefaultVersionValidator() {
        }

        @Override
        public void validate(@NotNull String version) {
            try {
                int versionNumber = Integer.parseInt(version);
                if (versionNumber < 0) {
                    throw new BadAttestationStatementException("The version number of Google Play Services responsible for providing the SafetyNet API doesn't conform minimal requirement.");
                }
            }
            catch (NumberFormatException e) {
                throw new BadAttestationStatementException("`ver` in android safetynet attestation statement cannot be parsed as number.");
            }
        }
    }
}

