/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.validator.exception.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttestationCertificate {
    private static final int CERTIFICATE_VERSION_3 = 3;
    private static final int NON_CA = -1;
    private final X509Certificate certificate;

    public AttestationCertificate(@NotNull X509Certificate certificate) {
        this.certificate = certificate;
    }

    private static Map<String, Object> toMap(Rdn rdn) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Attributes attributes = rdn.toAttributes();
            NamingEnumeration<String> ids = rdn.toAttributes().getIDs();
            while (ids.hasMore()) {
                String id = ids.next();
                map.put(id, attributes.get(id).get());
            }
            return map;
        }
        catch (NamingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @NotNull
    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Nullable
    public String getSubjectCountry() {
        return this.getValue("C");
    }

    @Nullable
    public String getSubjectOrganization() {
        return this.getValue("O");
    }

    @Nullable
    public String getSubjectOrganizationUnit() {
        return this.getValue("OU");
    }

    @Nullable
    public String getSubjectCommonName() {
        return this.getValue("CN");
    }

    public void validate() {
        if (this.certificate.getVersion() != 3) {
            throw new CertificateException("Attestation certificate must be version 3");
        }
        String country = this.getSubjectCountry();
        if (country == null || country.isEmpty()) {
            throw new CertificateException("Subject-C must be present");
        }
        String organization = this.getSubjectOrganization();
        if (organization == null || organization.isEmpty()) {
            throw new CertificateException("Subject-O must be present");
        }
        String organizationUnit = this.getSubjectOrganizationUnit();
        if (organizationUnit == null || !organizationUnit.equals("Authenticator Attestation")) {
            throw new CertificateException("Subject-OU must be present");
        }
        String commonName = this.getSubjectCommonName();
        if (commonName == null || commonName.isEmpty()) {
            throw new CertificateException("Subject-CN must be present");
        }
        if (this.certificate.getBasicConstraints() != -1) {
            throw new CertificateException("Attestation certificate must not be CA certificate");
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttestationCertificate that = (AttestationCertificate)o;
        return Objects.equals(this.certificate, that.certificate);
    }

    public int hashCode() {
        return Objects.hash(this.certificate);
    }

    @Nullable
    String getValue(@NotNull String name) {
        try {
            LdapName subjectDN = new LdapName(this.getCertificate().getSubjectX500Principal().getName());
            Map<String, Object> map = subjectDN.getRdns().stream().flatMap(rdn -> AttestationCertificate.toMap(rdn).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return (String)map.get(name);
        }
        catch (InvalidNameException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

