/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webauthn4j.data.KeyProtectionType;
import com.webauthn4j.data.MatcherProtectionType;
import com.webauthn4j.data.UserVerificationMethod;
import com.webauthn4j.util.AssertUtil;
import java.util.AbstractList;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UvmEntry
extends AbstractList<Number> {
    private final Number[] array;

    @JsonCreator
    public UvmEntry(@NonNull Number[] value) {
        AssertUtil.notNull((Object)value, (String)"value must not be null");
        this.array = (Number[])value.clone();
    }

    public UvmEntry(@NonNull UserVerificationMethod userVerificationMethod, @NonNull KeyProtectionType keyProtectionType, @NonNull MatcherProtectionType matcherProtectionType) {
        Number[] numbers = new Number[]{userVerificationMethod.getValue(), keyProtectionType.getValue(), matcherProtectionType.getValue()};
        this.array = numbers;
    }

    @JsonValue
    private @NonNull Number[] getValue() {
        return this.array;
    }

    @Override
    public @NonNull Number get(int index) {
        return this.array[index];
    }

    @Override
    public int size() {
        return this.array.length;
    }

    public @NonNull UserVerificationMethod getUserVerificationMethod() {
        if (this.array.length <= 0) {
            throw new IllegalStateException("UvmEntry doesn't have sufficient elements. UserVerificationMethod is not included.");
        }
        return UserVerificationMethod.create(this.array[0].intValue());
    }

    public @NonNull KeyProtectionType getKeyProtectionType() {
        if (this.array.length <= 1) {
            throw new IllegalStateException("UvmEntry doesn't have sufficient elements. KeyProtectionType is not included.");
        }
        return KeyProtectionType.create(this.array[1].intValue());
    }

    public @NonNull MatcherProtectionType getMatcherProtectionType() {
        if (this.array.length <= 2) {
            throw new IllegalStateException("UvmEntry doesn't have sufficient elements. MatcherProtectionType is not included.");
        }
        return MatcherProtectionType.create(this.array[2].intValue());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UvmEntry uvmEntry = (UvmEntry)o;
        return Arrays.equals(this.array, uvmEntry.array);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.array);
    }
}

