/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.util.AssertUtil;
import java.net.URI;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Origin {
    private static final String SCHEME_HTTPS = "https";
    private static final String SCHEME_HTTP = "http";
    private final String scheme;
    private String host;
    private final Integer port;
    private final String schemeSpecificPart;
    private final boolean explicitPortNotation;

    public Origin(@NonNull String originUrl) {
        AssertUtil.notNull((Object)originUrl, (String)"originUrl must not be null");
        URI uri = URI.create(originUrl);
        this.scheme = Origin.toLowerCase(uri.getScheme());
        if (SCHEME_HTTPS.equals(this.scheme) || SCHEME_HTTP.equals(this.scheme)) {
            this.host = Origin.toLowerCase(uri.getHost());
            int originPort = uri.getPort();
            if (originPort == -1) {
                this.explicitPortNotation = false;
                originPort = SCHEME_HTTPS.equals(this.scheme) ? 443 : 80;
            } else {
                this.explicitPortNotation = true;
            }
            this.port = originPort;
            String schemeSpecificPartStr = "//" + this.host;
            if (this.explicitPortNotation) {
                schemeSpecificPartStr = schemeSpecificPartStr + ":" + this.port;
            }
            this.schemeSpecificPart = schemeSpecificPartStr;
        } else {
            this.explicitPortNotation = uri.getPort() != -1;
            this.port = null;
            this.schemeSpecificPart = uri.getSchemeSpecificPart();
        }
    }

    public static @NonNull Origin create(@NonNull String value) {
        try {
            return new Origin(value);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("value is out of range: null", e);
        }
    }

    @JsonCreator
    private static @NonNull Origin deserialize(@NonNull String value) throws InvalidFormatException {
        try {
            return Origin.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value has an invalid syntax:'" + value + "'", (Object)value, Origin.class);
        }
    }

    private static @Nullable String toLowerCase(@Nullable String s) {
        return s == null ? null : s.toLowerCase();
    }

    public @NonNull String getScheme() {
        return this.scheme;
    }

    public @Nullable String getHost() {
        return this.host;
    }

    public @Nullable Integer getPort() {
        return this.port;
    }

    public @NonNull String getSchemeSpecificPart() {
        return this.schemeSpecificPart;
    }

    @JsonValue
    public @NonNull String toString() {
        if (this.scheme == null) {
            return this.schemeSpecificPart;
        }
        switch (this.scheme) {
            case "https": 
            case "http": {
                String result = this.scheme + "://" + this.host;
                if (this.explicitPortNotation) {
                    result = result + ":" + this.port;
                }
                return result;
            }
        }
        return this.scheme + ":" + this.schemeSpecificPart;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Origin origin = (Origin)o;
        if (SCHEME_HTTPS.equals(this.scheme) || SCHEME_HTTP.equals(this.scheme)) {
            return Objects.equals(this.scheme, origin.scheme) && Objects.equals(this.host, origin.host) && Objects.equals(this.port, origin.port);
        }
        return Objects.equals(this.scheme, origin.scheme) && Objects.equals(this.schemeSpecificPart, origin.schemeSpecificPart);
    }

    public int hashCode() {
        if (SCHEME_HTTPS.equals(this.scheme) || SCHEME_HTTP.equals(this.scheme)) {
            return Objects.hash(this.scheme, this.host, this.port);
        }
        return Objects.hash(this.scheme, this.schemeSpecificPart);
    }
}

