/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.AuthenticatorAttachment;
import com.webauthn4j.data.ResidentKeyRequirement;
import com.webauthn4j.data.UserVerificationRequirement;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticatorSelectionCriteria {
    private final AuthenticatorAttachment authenticatorAttachment;
    private final Boolean requireResidentKey;
    private final ResidentKeyRequirement residentKey;
    private final UserVerificationRequirement userVerification;

    @JsonCreator
    public AuthenticatorSelectionCriteria(@JsonProperty(value="authenticatorAttachment") @Nullable AuthenticatorAttachment authenticatorAttachment, @JsonProperty(value="requireResidentKey") @Nullable Boolean requireResidentKey, @JsonProperty(value="residentKey") @Nullable ResidentKeyRequirement residentKey, @JsonProperty(value="userVerification") @Nullable UserVerificationRequirement userVerification) {
        this.authenticatorAttachment = authenticatorAttachment;
        this.requireResidentKey = requireResidentKey;
        this.residentKey = residentKey;
        this.userVerification = userVerification;
    }

    public AuthenticatorSelectionCriteria(@Nullable AuthenticatorAttachment authenticatorAttachment, @Nullable ResidentKeyRequirement residentKey, @Nullable UserVerificationRequirement userVerification) {
        this(authenticatorAttachment, false, residentKey, userVerification);
    }

    public AuthenticatorSelectionCriteria(@Nullable AuthenticatorAttachment authenticatorAttachment, @Nullable Boolean requireResidentKey, @Nullable UserVerificationRequirement userVerification) {
        this(authenticatorAttachment, requireResidentKey, null, userVerification);
    }

    public @Nullable AuthenticatorAttachment getAuthenticatorAttachment() {
        return this.authenticatorAttachment;
    }

    public @Nullable Boolean isRequireResidentKey() {
        return this.requireResidentKey;
    }

    public @Nullable ResidentKeyRequirement getResidentKey() {
        return this.residentKey;
    }

    public @Nullable UserVerificationRequirement getUserVerification() {
        return this.userVerification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorSelectionCriteria that = (AuthenticatorSelectionCriteria)o;
        return Objects.equals(this.authenticatorAttachment, that.authenticatorAttachment) && Objects.equals(this.requireResidentKey, that.requireResidentKey) && Objects.equals(this.residentKey, that.residentKey) && Objects.equals(this.userVerification, that.userVerification);
    }

    public int hashCode() {
        return Objects.hash(this.authenticatorAttachment, this.requireResidentKey, this.residentKey, this.userVerification);
    }

    public String toString() {
        return "AuthenticatorSelectionCriteria(authenticatorAttachment=" + this.authenticatorAttachment + ", requireResidentKey=" + this.requireResidentKey + ", residentKey=" + this.residentKey + ", userVerification=" + this.userVerification + ")";
    }
}

