/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.PublicKeyCredentialType;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CollectionUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PublicKeyCredentialDescriptor
implements Serializable {
    private final PublicKeyCredentialType type;
    private final byte[] id;
    private final Set<AuthenticatorTransport> transports;

    @JsonCreator
    public PublicKeyCredentialDescriptor(@JsonProperty(value="type") @NonNull PublicKeyCredentialType type, @JsonProperty(value="id") @NonNull byte[] id, @JsonProperty(value="transports") @Nullable Set<AuthenticatorTransport> transports) {
        AssertUtil.notNull((Object)type, (String)"type must not be null");
        AssertUtil.notNull((Object)id, (String)"id must not be null");
        this.type = type;
        this.id = ArrayUtil.clone((byte[])id);
        this.transports = CollectionUtil.unmodifiableSet(transports);
    }

    public PublicKeyCredentialType getType() {
        return this.type;
    }

    public byte[] getId() {
        return ArrayUtil.clone((byte[])this.id);
    }

    public Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredentialDescriptor that = (PublicKeyCredentialDescriptor)o;
        return Objects.equals(this.type, that.type) && Arrays.equals(this.id, that.id) && Objects.equals(this.transports, that.transports);
    }

    public int hashCode() {
        int result = Objects.hash(this.type, this.transports);
        result = 31 * result + Arrays.hashCode(this.id);
        return result;
    }

    public String toString() {
        return "PublicKeyCredentialDescriptor(type=" + this.type + ", id=" + ArrayUtil.toHexString((byte[])this.id) + ", transports=" + this.transports + ")";
    }
}

