/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import java.util.Arrays;
import java.util.Objects;

public enum AuthenticationAlgorithm {
    SECP256R1_ECDSA_SHA256_RAW(1, "secp256r1_ecdsa_sha256_raw"),
    SECP256R1_ECDSA_SHA256_DER(2, "secp256r1_ecdsa_sha256_der"),
    RSASSA_PSS_SHA256_RAW(3, "rsassa_pss_sha256_raw"),
    RSASSA_PSS_SHA256_DER(4, "rsassa_pss_sha256_der"),
    SECP256K1_ECDSA_SHA256_RAW(5, "secp256k1_ecdsa_sha256_raw"),
    SECP256K1_ECDSA_SHA256_DER(6, "secp256k1_ecdsa_sha256_der"),
    SM2_SM3_RAW(7, "sm2_sm3_raw"),
    RSA_EMSA_PKCS1_SHA256_RAW(8, "rsa_emsa_pkcs1_sha256_raw"),
    RSA_EMSA_PKCS1_SHA256_DER(9, "rsa_emsa_pkcs1_sha256_der"),
    RSASSA_PSS_SHA384_RAW(10, "rsassa_pss_sha384_raw"),
    RSASSA_PSS_SHA512_RAW(11, "rsassa_pss_sha512_raw"),
    RSASSA_PKCSV15_SHA256_RAW(12, "rsassa_pkcsv15_sha256_raw"),
    RSASSA_PKCSV15_SHA384_RAW(13, "rsassa_pkcsv15_sha384_raw"),
    RSASSA_PKCSV15_SHA512_RAW(14, "rsassa_pkcsv15_sha512_raw"),
    RSASSA_PKCSV15_SHA1_RAW(15, "rsassa_pkcsv15_sha1_raw"),
    SECP384R1_ECDSA_SHA384_RAW(16, "secp384r1_ecdsa_sha384_raw"),
    SECP521R1_ECDSA_SHA512_RAW(17, "secp512r1_ecdsa_sha512_raw"),
    ED25519_EDDSA_SHA512_RAW(18, "ed25519_eddsa_sha512_raw");

    private static final String VALUE_OUT_OF_RANGE_TEMPLATE = "value %s is out of range";
    private final int value;
    private final String string;

    private AuthenticationAlgorithm(int value, String string2) {
        this.value = value;
        this.string = string2;
    }

    public static AuthenticationAlgorithm create(int value) {
        if (value > 65535 || value < 0) {
            throw new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value));
        }
        return Arrays.stream(AuthenticationAlgorithm.values()).filter(item -> item.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    public static AuthenticationAlgorithm create(String value) {
        return Arrays.stream(AuthenticationAlgorithm.values()).filter(item -> Objects.equals(item.string, value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.string;
    }
}

