/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.TokenBinding;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CollectedClientData
implements Serializable {
    private final ClientDataType type;
    private final Challenge challenge;
    private final Origin origin;
    private final Boolean crossOrigin;
    private final TokenBinding tokenBinding;

    @JsonCreator
    public CollectedClientData(@JsonProperty(value="type") @NonNull ClientDataType type, @JsonProperty(value="challenge") @NonNull Challenge challenge, @JsonProperty(value="origin") @NonNull Origin origin, @JsonProperty(value="crossOrigin") @Nullable Boolean crossOrigin, @JsonProperty(value="tokenBinding") @Nullable TokenBinding tokenBinding) {
        AssertUtil.notNull((Object)type, (String)"type must not be null");
        AssertUtil.notNull((Object)challenge, (String)"challenge must not be null");
        AssertUtil.notNull((Object)origin, (String)"origin must not be null");
        this.type = type;
        this.challenge = challenge;
        this.origin = origin;
        this.crossOrigin = crossOrigin;
        this.tokenBinding = tokenBinding;
    }

    public CollectedClientData(@JsonProperty(value="type") @NonNull ClientDataType type, @JsonProperty(value="challenge") @NonNull Challenge challenge, @JsonProperty(value="origin") @NonNull Origin origin, @JsonProperty(value="tokenBinding") @Nullable TokenBinding tokenBinding) {
        this(type, challenge, origin, null, tokenBinding);
    }

    public @NonNull ClientDataType getType() {
        return this.type;
    }

    public @NonNull Challenge getChallenge() {
        return this.challenge;
    }

    public @NonNull Origin getOrigin() {
        return this.origin;
    }

    public @NonNull Boolean getCrossOrigin() {
        return this.crossOrigin;
    }

    public @Nullable TokenBinding getTokenBinding() {
        return this.tokenBinding;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectedClientData that = (CollectedClientData)o;
        return this.type == that.type && Objects.equals(this.challenge, that.challenge) && Objects.equals(this.origin, that.origin) && Objects.equals(this.crossOrigin, that.crossOrigin) && Objects.equals(this.tokenBinding, that.tokenBinding);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.challenge, this.origin, this.crossOrigin, this.tokenBinding);
    }

    public String toString() {
        return "CollectedClientData(type=" + this.type + ", challenge=" + this.challenge + ", origin=" + this.origin + ", crossOrigin=" + this.crossOrigin + ", tokenBinding=" + this.tokenBinding + ')';
    }
}

