/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webauthn4j.util.AssertUtil;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class UserVerificationRequirement {
    public static final UserVerificationRequirement REQUIRED = new UserVerificationRequirement("required");
    public static final UserVerificationRequirement PREFERRED = new UserVerificationRequirement("preferred");
    public static final UserVerificationRequirement DISCOURAGED = new UserVerificationRequirement("discouraged");
    private final String value;

    private UserVerificationRequirement(String value) {
        this.value = value;
    }

    @JsonCreator
    public static UserVerificationRequirement create(@NonNull String value) {
        AssertUtil.notNull((Object)value, (String)"value must not be null.");
        switch (value) {
            case "required": {
                return REQUIRED;
            }
            case "preferred": {
                return PREFERRED;
            }
            case "discouraged": {
                return DISCOURAGED;
            }
        }
        return new UserVerificationRequirement(value);
    }

    @JsonValue
    public @NonNull String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserVerificationRequirement that = (UserVerificationRequirement)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

