/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.webauthn4j.converter.jackson.deserializer.json.ChallengeDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.CredentialProtectionPolicyDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.JWSHeaderDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.X509CertificateDeserializer;
import com.webauthn4j.converter.jackson.serializer.json.ChallengeSerializer;
import com.webauthn4j.converter.jackson.serializer.json.CredentialProtectionPolicySerializer;
import com.webauthn4j.converter.jackson.serializer.json.JWSHeaderSerializer;
import com.webauthn4j.converter.jackson.serializer.json.OriginSerializer;
import com.webauthn4j.converter.jackson.serializer.json.X509CertificateSerializer;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.extension.CredentialProtectionPolicy;
import com.webauthn4j.data.jws.JWSHeader;
import com.webauthn4j.util.AssertUtil;
import java.security.cert.X509Certificate;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WebAuthnJSONModule
extends SimpleModule {
    public WebAuthnJSONModule(@NonNull ObjectConverter objectConverter) {
        super("WebAuthnJSONModule");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.addDeserializer(Challenge.class, (JsonDeserializer)new ChallengeDeserializer());
        this.addDeserializer(CredentialProtectionPolicy.class, (JsonDeserializer)new CredentialProtectionPolicyDeserializer());
        this.addDeserializer(JWSHeader.class, (JsonDeserializer)new JWSHeaderDeserializer());
        this.addDeserializer(X509Certificate.class, (JsonDeserializer)new X509CertificateDeserializer());
        this.addSerializer((JsonSerializer)new ChallengeSerializer());
        this.addSerializer((JsonSerializer)new CredentialProtectionPolicySerializer());
        this.addSerializer((JsonSerializer)new JWSHeaderSerializer());
        this.addSerializer((JsonSerializer)new OriginSerializer());
        this.addSerializer((JsonSerializer)new X509CertificateSerializer());
    }
}

