/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.AssertionSignatureValidator;
import com.webauthn4j.validator.AuthenticationObject;
import com.webauthn4j.validator.AuthenticatorExtensionValidator;
import com.webauthn4j.validator.BeanAssertUtil;
import com.webauthn4j.validator.ChallengeValidator;
import com.webauthn4j.validator.ClientExtensionValidator;
import com.webauthn4j.validator.CoreMaliciousCounterValueHandler;
import com.webauthn4j.validator.CustomAuthenticationValidator;
import com.webauthn4j.validator.DefaultCoreMaliciousCounterValueHandler;
import com.webauthn4j.validator.OriginValidator;
import com.webauthn4j.validator.OriginValidatorImpl;
import com.webauthn4j.validator.RpIdHashValidator;
import com.webauthn4j.validator.TokenBindingValidator;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import com.webauthn4j.validator.exception.CrossOriginException;
import com.webauthn4j.validator.exception.InconsistentClientDataTypeException;
import com.webauthn4j.validator.exception.NotAllowedCredentialIdException;
import com.webauthn4j.validator.exception.UserNotPresentException;
import com.webauthn4j.validator.exception.UserNotVerifiedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticationDataValidator {
    private final ChallengeValidator challengeValidator = new ChallengeValidator();
    private final TokenBindingValidator tokenBindingValidator = new TokenBindingValidator();
    private final RpIdHashValidator rpIdHashValidator = new RpIdHashValidator();
    private final AssertionSignatureValidator assertionSignatureValidator = new AssertionSignatureValidator();
    private final ClientExtensionValidator clientExtensionValidator = new ClientExtensionValidator();
    private final AuthenticatorExtensionValidator authenticatorExtensionValidator = new AuthenticatorExtensionValidator();
    private final List<CustomAuthenticationValidator> customAuthenticationValidators;
    private OriginValidator originValidator = new OriginValidatorImpl();
    private CoreMaliciousCounterValueHandler maliciousCounterValueHandler = new DefaultCoreMaliciousCounterValueHandler();
    private boolean crossOriginAllowed = false;

    public AuthenticationDataValidator(@NonNull List<CustomAuthenticationValidator> customAuthenticationValidators) {
        AssertUtil.notNull(customAuthenticationValidators, (String)"customAuthenticationValidators must not be null");
        this.customAuthenticationValidators = customAuthenticationValidators;
    }

    public AuthenticationDataValidator() {
        this.customAuthenticationValidators = new ArrayList<CustomAuthenticationValidator>();
    }

    public void validate(@NonNull AuthenticationData authenticationData, @NonNull AuthenticationParameters authenticationParameters) {
        BeanAssertUtil.validate(authenticationData);
        AssertUtil.notNull((Object)authenticationParameters, (String)"authenticationParameters must not be null");
        AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions = authenticationData.getClientExtensions();
        byte[] credentialId = authenticationData.getCredentialId();
        List<byte[]> allowCredentials = authenticationParameters.getAllowCredentials();
        this.validateCredentialId(credentialId, allowCredentials);
        byte[] cData = authenticationData.getCollectedClientDataBytes();
        byte[] aData = authenticationData.getAuthenticatorDataBytes();
        CollectedClientData collectedClientData = authenticationData.getCollectedClientData();
        AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData = authenticationData.getAuthenticatorData();
        ServerProperty serverProperty = authenticationParameters.getServerProperty();
        BeanAssertUtil.validate(collectedClientData);
        BeanAssertUtil.validate(authenticatorData);
        this.validateAuthenticatorData(authenticatorData);
        Authenticator authenticator = authenticationParameters.getAuthenticator();
        AuthenticationObject authenticationObject = new AuthenticationObject(credentialId, authenticatorData, aData, collectedClientData, cData, clientExtensions, serverProperty, authenticator);
        if (!Objects.equals((Object)collectedClientData.getType(), (Object)ClientDataType.GET)) {
            throw new InconsistentClientDataTypeException("ClientData.type must be 'get' on authentication, but it isn't.");
        }
        this.challengeValidator.validate(collectedClientData, serverProperty);
        this.originValidator.validate(authenticationObject);
        this.validateClientDataCrossOrigin(collectedClientData);
        this.tokenBindingValidator.validate(collectedClientData.getTokenBinding(), serverProperty.getTokenBindingId());
        this.rpIdHashValidator.validate(authenticatorData.getRpIdHash(), serverProperty);
        if (authenticationParameters.isUserPresenceRequired() && !authenticatorData.isFlagUP()) {
            throw new UserNotPresentException("Validator is configured to check user present, but UP flag in authenticatorData is not set.");
        }
        if (authenticationParameters.isUserVerificationRequired() && !authenticatorData.isFlagUV()) {
            throw new UserNotVerifiedException("Validator is configured to check user verified, but UV flag in authenticatorData is not set.");
        }
        AuthenticationExtensionsAuthenticatorOutputs<AuthenticationExtensionAuthenticatorOutput> authenticationExtensionsAuthenticatorOutputs = authenticatorData.getExtensions();
        this.clientExtensionValidator.validate(clientExtensions);
        this.authenticatorExtensionValidator.validate(authenticationExtensionsAuthenticatorOutputs);
        this.assertionSignatureValidator.validate(authenticationData, authenticator.getAttestedCredentialData().getCOSEKey());
        long presentedSignCount = authenticatorData.getSignCount();
        long storedSignCount = authenticator.getCounter();
        if (presentedSignCount > 0L || storedSignCount > 0L) {
            if (presentedSignCount > storedSignCount) {
                authenticator.setCounter(presentedSignCount);
            } else {
                this.maliciousCounterValueHandler.maliciousCounterValueDetected(authenticationObject);
            }
        }
        for (CustomAuthenticationValidator customAuthenticationValidator : this.customAuthenticationValidators) {
            customAuthenticationValidator.validate(authenticationObject);
        }
    }

    void validateCredentialId(byte[] credentialId, @Nullable List<byte[]> allowCredentials) {
        if (allowCredentials != null && allowCredentials.stream().noneMatch(item -> Arrays.equals(item, credentialId))) {
            throw new NotAllowedCredentialIdException("credentialId not listed in allowCredentials is used.");
        }
    }

    void validateClientDataCrossOrigin(CollectedClientData collectedClientData) {
        if (!this.crossOriginAllowed && Objects.equals(true, collectedClientData.getCrossOrigin())) {
            throw new CrossOriginException("Cross-origin request is prohibited. Relax AuthenticationDataValidator config if necessary.");
        }
    }

    void validateAuthenticatorData(@NonNull AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        if (authenticatorData.getAttestedCredentialData() != null) {
            throw new ConstraintViolationException("attestedCredentialData must be null on authentication");
        }
    }

    public @NonNull CoreMaliciousCounterValueHandler getMaliciousCounterValueHandler() {
        return this.maliciousCounterValueHandler;
    }

    public void setMaliciousCounterValueHandler(@NonNull CoreMaliciousCounterValueHandler maliciousCounterValueHandler) {
        AssertUtil.notNull((Object)maliciousCounterValueHandler, (String)"maliciousCounterValueHandler must not be null");
        this.maliciousCounterValueHandler = maliciousCounterValueHandler;
    }

    public OriginValidator getOriginValidator() {
        return this.originValidator;
    }

    public void setOriginValidator(OriginValidator originValidator) {
        this.originValidator = originValidator;
    }

    public @NonNull List<CustomAuthenticationValidator> getCustomAuthenticationValidators() {
        return this.customAuthenticationValidators;
    }

    public boolean isCrossOriginAllowed() {
        return this.crossOriginAllowed;
    }

    public void setCrossOriginAllowed(boolean crossOriginAllowed) {
        this.crossOriginAllowed = crossOriginAllowed;
    }
}

