/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.client;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.extension.SingleValueExtensionOutputBase;
import com.webauthn4j.data.extension.UvmEntries;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.CredentialPropertiesExtensionClientOutput;
import com.webauthn4j.data.extension.client.CredentialPropertiesOutput;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.data.extension.client.FIDOAppIDExtensionClientOutput;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.data.extension.client.UserVerificationMethodExtensionClientOutput;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticationExtensionsClientOutputs<T extends ExtensionClientOutput>
implements Serializable {
    @JsonIgnore
    private final Map<String, Serializable> unknowns = new HashMap<String, Serializable>();
    @JsonProperty
    private Boolean appid;
    @JsonProperty
    private UvmEntries uvm;
    @JsonProperty
    private CredentialPropertiesOutput credProps;
    @JsonIgnore
    private Map<Class<? extends T>, T> extensions;

    @JsonAnySetter
    private void setUnknowns(@NonNull String name, @Nullable Serializable value) {
        this.unknowns.put(name, value);
    }

    @JsonAnyGetter
    private @NonNull Map<String, Serializable> getUnknowns() {
        return this.unknowns;
    }

    @JsonIgnore
    public @NonNull Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (this.appid != null) {
            keys.add("appid");
        }
        if (this.uvm != null) {
            keys.add("uvm");
        }
        if (this.credProps != null) {
            keys.add("credProps");
        }
        keys.addAll(this.getUnknownKeys());
        return keys;
    }

    @JsonIgnore
    public @NonNull Set<String> getUnknownKeys() {
        return this.unknowns.keySet();
    }

    @JsonIgnore
    public @Nullable Serializable getValue(@NonNull String key) {
        switch (key) {
            case "appid": {
                return this.appid;
            }
            case "uvm": {
                return this.uvm;
            }
            case "credProps": {
                return this.credProps;
            }
        }
        return this.unknowns.get(key);
    }

    @JsonIgnore
    public @Nullable Boolean getAppid() {
        return this.appid;
    }

    @JsonIgnore
    public @Nullable UvmEntries getUvm() {
        return this.uvm;
    }

    @JsonIgnore
    public @Nullable CredentialPropertiesOutput getCredProps() {
        return this.credProps;
    }

    public <E extends T> @Nullable E getExtension(@NonNull Class<E> tClass) {
        return (E)((ExtensionClientOutput)this.getExtensions().get(tClass));
    }

    @JsonIgnore
    public @NonNull Map<Class<? extends T>, T> getExtensions() {
        if (this.extensions == null) {
            HashMap<Class<CredentialPropertiesExtensionClientOutput>, SingleValueExtensionOutputBase> map = new HashMap<Class<CredentialPropertiesExtensionClientOutput>, SingleValueExtensionOutputBase>();
            if (this.appid != null) {
                map.put(FIDOAppIDExtensionClientOutput.class, new FIDOAppIDExtensionClientOutput(this.appid));
            }
            if (this.uvm != null) {
                map.put(UserVerificationMethodExtensionClientOutput.class, new UserVerificationMethodExtensionClientOutput(this.uvm));
            }
            if (this.credProps != null) {
                map.put(CredentialPropertiesExtensionClientOutput.class, new CredentialPropertiesExtensionClientOutput(this.credProps));
            }
            this.extensions = Collections.unmodifiableMap(map);
        }
        return this.extensions;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationExtensionsClientOutputs that = (AuthenticationExtensionsClientOutputs)o;
        return Objects.equals(this.appid, that.appid) && Objects.equals(this.uvm, that.uvm) && Objects.equals(this.credProps, that.credProps) && Objects.equals(this.unknowns, that.unknowns);
    }

    public int hashCode() {
        return Objects.hash(this.appid, this.uvm, this.credProps, this.unknowns);
    }

    public static class BuilderForAuthentication {
        private final Map<String, Serializable> unknowns = new HashMap<String, Serializable>();
        private Boolean appid;
        private UvmEntries uvm;

        public @NonNull AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> build() {
            AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> instance = new AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput>();
            ((AuthenticationExtensionsClientOutputs)instance).appid = this.appid;
            ((AuthenticationExtensionsClientOutputs)instance).uvm = this.uvm;
            ((AuthenticationExtensionsClientOutputs)instance).unknowns.putAll(this.unknowns);
            return instance;
        }

        public @NonNull BuilderForAuthentication setAppid(@Nullable Boolean appid) {
            this.appid = appid;
            return this;
        }

        public @NonNull BuilderForAuthentication setUvm(@Nullable UvmEntries uvm) {
            this.uvm = uvm;
            return this;
        }

        public @NonNull BuilderForAuthentication set(@NonNull String key, @Nullable Serializable value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }

    public static class BuilderForRegistration {
        private final Map<String, Serializable> unknowns = new HashMap<String, Serializable>();
        private UvmEntries uvm;
        private CredentialPropertiesOutput credProps;

        public @NonNull AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> build() {
            AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> instance = new AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput>();
            ((AuthenticationExtensionsClientOutputs)instance).uvm = this.uvm;
            ((AuthenticationExtensionsClientOutputs)instance).credProps = this.credProps;
            ((AuthenticationExtensionsClientOutputs)instance).unknowns.putAll(this.unknowns);
            return instance;
        }

        public @NonNull BuilderForRegistration setUvm(@Nullable UvmEntries uvm) {
            this.uvm = uvm;
            return this;
        }

        public @NonNull BuilderForRegistration setCredProps(@Nullable CredentialPropertiesOutput credProps) {
            this.credProps = credProps;
            return this;
        }

        public @NonNull BuilderForRegistration set(@NonNull String key, @Nullable Serializable value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }
}

